<?php // HybridAuth requires a session:
session_start(); 
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Twitter via HybridAuth</title>
</head>
<body>
	<h2>Your Twitter Account</h2>
<?php

// Identify and include the HybridAuth files:
$config = dirname(__FILE__) . '/hybridauth/config.php';
require_once('hybridauth/Hybrid/Auth.php');

// HybridAuth throws exceptions, so use a try...catch block:
try {

	// Create the HybridAuth object:
	$ha = new Hybrid_Auth( $config );
	
	// Authenticate (login) with Twitter:
	$t = $ha->authenticate('Twitter');

	// Confirm the login:
	if ($t->isUserConnected()) {
		
		// Grab the user's profile info:
		$profile = $t->getUserProfile();
		
		// Show the information:
		echo "<p><strong>Twitter Handle</strong>: <a href=\"{$profile->profileURL}\">{$profile->displayName}</a></p>
		<p><strong>Description</strong>: {$profile->description}</p>";
//		echo '<pre>' . print_r($profile, 1) . '</pre>';
		
		// Get some other Twitter account information:
		$account = $t->api()->get('users/show.json', array('user_id' => $profile->identifier, 'screen_name'=>$profile->displayName));
//		echo '<pre>' . print_r($account, 1) . '</pre>';
		
		// Print those details:
		echo "<p><strong>Following</strong>: {$account->friends_count}</p>
		<p><strong>Followers</strong>: {$account->followers_count}</p>
		<p><strong>Latest Tweet</strong>: {$account->status->text}</p>";

		// Logout:
		$t->logout();
		
	} else { // Not authenticated.

	}

} catch (Exception $e) { 
	
	// See HybridAuth examples for ways to handle the exception.
	echo $e->getMessage();
	 
}
?>
</body>
</html>