/* temp_conversion2.c - Script 5.5 - revision of Script 5.4 (temp_conversion.c) */

#include <stdio.h>

int main(void) {
	
    float temp_i, temp_o; // Two temperatures: inputted and outputted.
	char which_i, which_o; // F or C: inputted and outputted.
	char junk; // For discarding extra input.
	
	// Prompt the user.
	printf ("Enter a temperature and indicate if it's Fahrenheit or Celsius [##.# C/F]: ");
	
	// Read the input as a conditional.
	if (scanf ("%f %c", &temp_i, &which_i) == 2) {
		
		// Make the conversion based upon which_i.
		switch (which_i) {
			
			// Celsius, convert to Fahrenheit.
			case 'C':
			case 'c':
				temp_o = (temp_i * (9.0/5.0)) + 32;
				which_o = 'F';
				break;
				
				// Fahrenheit, convert to Celsius.
			case 'F':
			case 'f':
				temp_o = (temp_i - 32) * (5.0/9.0);
				which_o = 'C';
				break;
				
				// Problem: neither C nor F entered, set which_o to FALSE.
			default:
				which_o = 0;
				break;
				
		} // End of switch.
		
		// Print the results, using which_o to indicate if it worked.
		if (which_o) {
			printf ("%0.1f %c is %0.1f %c.\n", temp_i, which_i, temp_o, which_o);
		} else {
			printf ("You failed to enter C or F to indicate the current temperature.\n");
		}

	} else { // Didn't enter the right input.
		
		printf ("You failed to use the proper syntax.\n");
		
	} // End of main IF.
	
	// Discard any extra input.
	do {
		junk = getchar();
	} while (junk != '\n' );
			
	// Pause for the user to press Return or Enter.
    getchar(); 
	
    return 0;
	
}
