/* exchange3.c - Script 6.7 - rewrite of Scripts 6.4 and 6.5 (exchange.c and exchange2.c) */

#include <stdio.h>

int main (void) {
	
	const int NUM = 10; // Constant for number of array elements.
	double amounts[2][NUM]; // Holds different currency amounts.
	
	// titles stores the table headers.
	char titles[2][6] = {
		{"Pesos"},
		{"Euros"}
	};
	
	double rates[] = {11.317466, 0.823859}; // Pesos and Euros, respectively.
	
	unsigned int i, j; // Loop counters.
	
	// Print the header.
	printf ("US Dollar amounts converted to Mexican Pesos and Euros:\n\n");
	
	for (i = 0; i < 2; i++) {
		printf ("%10s %10s\n", "Dollars", titles[i]);

		// Loop through the array.
		for (j = 0; j < NUM; j++) {
			
			// Array values are in $5 increments.
			amounts[i][j] = (j + 1) * 5.00;
			
			// Print original amounts and conversion.
			printf ("%10.2f %10.2f\n", amounts[i][j], (amounts[i][j] * rates[i]));
			
		} // End of inner for loop.
		
		printf ("\n\n");
		
	} // End of outer for loop.
	
	/* Wait for user to press Enter or Return. */
	getchar();
	
	return 0;
	
}