/* exchange_function.c - Script 7.2 */

#include <stdio.h>

void make_exchange_table(float rate, char title[]); /* Function prototype. */

int main (void) {
	
	// Show Pesos.
	make_exchange_table (11.317466, "Pesos");

	// Show Euros.
	make_exchange_table (0.823859, "Euros");
	
	// Wait for user to press Enter or Return.
	getchar();
	
	return 0;
	
} /* End of main() function. */

/* This function displays a list of currency conversions. */
void make_exchange_table(float rate, char title[]) {	

	float i; // Loop variable.
	
	// Print the header.
	printf ("%10s %10s\n", "Dollars", title);
	
	// Loop through several increments.
	for (i = 10.00; i <= 100.00; i += 10.00) {
		
		// Print original amounts and conversion.
		printf ("%10.2f %10.2f\n", i, i * rate);
		
	}
	
	printf ("\n\n");
	
} /* End of make_exchange_table() function. */