/* inline.c - Script 7.4- rewrite of return_factorial.c (Script 7.3) */

#include <stdio.h>

unsigned long long int return_factorial (int num); /* Function prototype. */

 /* This function discards all of the input until a newline. */
inline void discard_input (void) {
	
	char junk; // To get rid of extra input.
	
	// Loop through the input and ignore it.
	while ( (junk = getchar()) != '\n' ) {
		continue;
	}
	
} /* End of discard_input() function. */

int main (void) {
	
	char input[3]; // Keyboard input.
	int number; // Number to work with.
	
	// Prompt the user.
	printf ("Enter a positive integer for which the factorial will be calculated: ");
	
	fgets (input, sizeof(input), stdin); // Read in the input.
	sscanf (input, "%d", &number);
	
	//  Check the input as a conditional.
	if (number > 0 ) {
		
		// Input is okay, print the input and the factorial.
		printf ("The factorial of %d is %llu.\n", number, return_factorial (number));
		
	} else { // Input not okay.
		printf ("You must enter a positive integer!\n");
	}
	
	discard_input(); /* Get rid of other input. */
	
    getchar(); /* Pause for the user to press Return or Enter. */
	
    return 0;
	
}

/* This function takes a number and returns its factorial. */
unsigned long long int return_factorial (int num) {
	
	unsigned long long  int sum = 1; // Factorial sum.
	unsigned int i; // Multiplier to be used in calculating factorial.
	
	// Loop through every multiplier up to and including num.
	for (sum = 1, i = 1; i <= num; ++i) {
		
		sum *= i; // Mulitply the current sum by the multiplier.
		
	}
	
	return sum;
	
} /* End of return_factorial() function. */