/* yards.c - Script 8.2 */

#include <stdio.h> /* Include directive. */

#define NUM_ELEMENTS 5 /* Number of array elements. */

int main (void) {
	
	unsigned int yards[NUM_ELEMENTS]; /* Array to store yard increments. */
	int i; /* Index variable. */
	
	/* Populate the array in increments of 5. */
	for (i = 0; i < NUM_ELEMENTS; i++) {
		yards[i] = (i + 1) * 5;
	}
	
	/* Print a header. */
	printf ("%10s %10s\n", "Yards", "Meters");
	
	/* Convert to meters and print. */
	for (i = 0; i < NUM_ELEMENTS; i++) {
		printf ("%10d %10.2f\n", yards[i], yards[i] * 0.9144);
	}
	
	getchar(); /* Wait for the user to press Enter or Return. */
	
	return 0;
	
}