/* pointer6.c - Script 9.6 */

#include <stdio.h>

void swap(int *first, int *second); /* Function prototype. */

int main(void) {
			
	/* Define and initialize two integer variables */
	int a = 5, b = 10;
	
	/* Print the initial variable values. */
	printf("At first, a = %d, b = %d.\n", a, b);
	
	/* Swap the variable values. */
	swap(&a, &b);
	
	/* Print the variables again. */
	printf("After swapping, a = %d, b = %d.\n", a, b);

	/* Pause and wait for input before terminating. */
	getchar();

	return 0;

} /* End of main function. */

/* Define swap(), taking pointers instead of values. */
void swap(int *first, int *second) {

	/* Using a third, temporary integer variable, 
	 * swap the values of the two variables whose
	 * addresses were passed as parameters.
	 * We use the dereferencing operator * to get
	 * at the variables' values. */
	int temp = *first;
	*first = *second;
	*second = temp;
	
} /* End of swap function. */

