/* function.c - Script 10.5 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

char *get_name(void); /* Function prototype. */

int main (void) {

	/* Define a char pointer variable
	 * to hold the base address of an array of
	 * chars, i.e. a string. */
	char *name = NULL;

	/* Call the subroutine and store the address
	 * value it returns in the pointer variable. */
	name = get_name();
	
	/* Check for success and abort upon failure. */
	assert(name != NULL);
	
	/* Print the name value. */
	printf("The entered name was: %s.\n", name);

	/* Return the block to the pool. */
	free(name);
	name = NULL;

	/* Pause and wait for input before terminating. */
	getchar();
	getchar();

	return 0;

} /* End of main() function. */


/* This function asks for a name and returns
 * a pointer to the character array with the name. */
char *get_name(void) {

	/* Allocate a memory block 100 bytes long. */
	char *input = malloc(100);
	
	/* Check if the allocation succeeded. */
	if (input == NULL) {
		printf("Unable to allocate memory!\n");
		return NULL;
	}
	
	/* Prompt the user for input. */
	printf("Enter your name: ");

	/* Store the input in the memory block. */
	scanf("%99s", input);
	
	/* Return the address of the memory block. */
	return input;

} /* End of get_name() function. */