/* resize.c - Script 10.4 */

#include <stdio.h>
#include <stdlib.h>

/* Function prototype for the sort comparison function. */
int sort(const void *x, const void *y);

int main (void) {

	/* Define an integer pointer variable. */
	int *numbers;
	
	/* Define an integer to hold the user's input read
	 * with scanf(). Define another one to hold the
	 * return value of scanf(). */
	int input, result;
	
	/* Define an integer to hold the current size of the
	 * dynamically growing array, another one to hold the
	 * index of the next free array element, and a for loop index
	 * counter. */
	int  size = 4, i, index = 0;

	/* Allocate the integer array to its initial size. */
	numbers = malloc(size * sizeof(int));
	
	/* Again note that we have left out the check for NULL. */

	/* Enter an infinite loop that will be left as soon
	 * as the user types the number zero or a non-digit
	 * character. */
	while (1) {
		
		/* Prompt the user for input and read a number
		 * using scanf. */
		printf("Enter a non-zero integer (or 0 to quit): ");
		result = scanf("%d", &input);

		/* If the number entered was zero, or if it
		 * was not a number at all, leave the infinite
		 * loop using the break statement. */
		if (result < 1 || input == 0) break;

		/* Before we store the number in our integer array,
		 * check to see if there is any room left. If there
		 * isn't,  call realloc() to dynamically grow it. */
		if (index == size) {
			size *= 1.5;
			numbers = realloc(numbers, size * sizeof(int));
			printf("Reallocation of the memory block. The size is now %d bytes.\n", size);
		}

		/* Store the new number into the next free slot. */
		numbers[index] = input;
		
		/* Increment the index so it indicates the next slot
		 * to be used for the next number. */
		index++;

	} /* End of while loop body. */


	/* At this point we have terminated the infinite
	 * loop. Now use the qsort() function to sort
	 * the numbers in the array into ascending order. */
	qsort(numbers, index, sizeof(int), sort);


	/* Print the numbers in a loop. */
	for (i = 0; i < index; i++) {
		printf("The value indexed at %d is %d.\n", i, numbers[i]);
	}


	/* Return the block to the pool. */
	free(numbers);
	numbers = NULL;

	/* Pause and wait for input before terminating. */
	getchar();
	getchar();

	return 0;

} /* End of main() function. */


/* This is a sort comparison function used
 * by the standard C library function qsort().
 * See the documentation for your C library for
 * details. */
int sort(const void *x, const void *y) {

	const int *a = x, *b = y;

	if (*a < *b) {
		return -1;
	} else if (*a > *b) {
		return 1;
	}

	return 0;

} /* End of sort() function. */