/* length.c - Script 11.2 - rewrite of ragged.c (Script 11.1) */

#include <stdio.h>
#include <string.h>

/* Set the different chapter titles as constant macros. */
#define CHAPTER0 "Introduction"
#define CHAPTER1 "Getting Started with C"
#define CHAPTER2 "Introduction to Data Types"
#define CHAPTER3 "Working with Numbers"
#define CHAPTER4 "Control Structures"

int main (void) {
	
	/* Create a multi-dimensional character array. */
	char chapters[5][27] = {{CHAPTER0}, {CHAPTER1}, {CHAPTER2}, {CHAPTER3}, {CHAPTER4}};

	/* Create an array of character pointers. */
	char *chapters_ptr[5] = {CHAPTER0, CHAPTER1, CHAPTER2, CHAPTER3, CHAPTER4};

	/* Declare three integers. */
	int i; /* Loop counter. */
	int chapters_count = 0, ptr_count = 0; /* Character counters. */

	/* Print the memory requirements of each variable. */
	printf ("The chapters array uses %lu bytes of memory.\n", sizeof(chapters));
	printf ("The chapters_ptr array uses %lu bytes of memory.\n", sizeof(chapters_ptr));

	/* Determine the total string length. */
	for (i = 0; i < 5; ++i) {
		chapters_count += strlen(chapters[i]);
	}
	
	/* Print the number of characters. */
	printf ("The chapters array contains %d characters.\n", chapters_count);

	/* Calculate the memory being used by the pointer array. */
	ptr_count = sizeof(chapters_ptr) + chapters_count + 5; /* Pointer size plus number of characters plus 5 (for the \0). */

	/* Print that result. */
	printf ("The chapters_ptr array -actually- uses %d bytes of memory.\n", ptr_count);

	getchar();
	return 0;
}