/* binary_read.c - Script 12.6 */

#include <stdio.h>

/* Set the file path and name. */
#define THEFILE "/Users/larry/Desktop/numbers.dat"

/* Number of items being written. */
#define ITEMS 50

int main (void) {
	
	/* Need a pointer of type FILE. */
    FILE *fp;
	
	int i; /* Loop counter. */
	int numbers[ITEMS]; /* Array of numbers. */
	
	/* Attempt to open the file for reading. */
	fp = fopen(THEFILE, "rb");
	
	if (fp != NULL) { /* The file is open. */
	
		printf("The contents of the numbers file:\n");
		
		/* Read the entire contents into the numbers array. */
		fread (numbers, sizeof(int), ITEMS, fp);
		
		/* Print each element. */
		for (i = 0; i < ITEMS; i++) {
			printf("%d\n", numbers[i]);
		}
		
	} else { 
		printf ("The file could not be opened.\n");
		return 1; /* Exit the function/application. */
	}

	/* Close the file. */
	if (fclose(fp) != 0) {
		printf ("The file could not be closed.\n");
	}
	
	getchar(); /* Pause. */
	return 0;
}