/* random_read.c - Script 12.7 */

#include <stdio.h>
#include <stdlib.h> /* For rand() and srand(). */
#include <time.h> * For time(), used with srand(). */

/* Set the file path and name. */
#define THEFILE "/Users/larry/Desktop/numbers.dat"

/* Number of items being written. */
#define ITEMS 50

int main (void) {
	
	/* Need a pointer of type FILE. */
    FILE *fp;
	
	/* Two integers are required. */
	int offset, number;

	/* Attempt to open the file for binary reading. */
	fp = fopen(THEFILE, "rb");
	
	if (fp != NULL) { /* The file is open. */
		
		/* Find a random offset in bytes. */
		srand((unsigned)time(NULL));
		offset = rand() % ITEMS;
		offset *= sizeof(int);
		
		/* Read in the number found at the random location. */
		fseek (fp, offset, SEEK_SET);
		fread (&number, sizeof(number), 1, fp);
		
		/* Print the number. */
		printf("Your lucky number is: %d.\n", number);

	} else { 
		printf ("The file could not be opened.\n");
		return 1; /* Exit the function/application. */
	}

	/* Close the file. */
	if (fclose(fp) != 0) {
		printf ("The file could not be closed.\n");
	}
	
	getchar(); /* Pause. */
	return 0;
}