/* read_weather.c - Script 13.2 */

#include <stdio.h>

/* Set the file path and name. */
#define THEFILE "/Users/Larry/Desktop/weather.dat"

int main (void) {
	
	/* Define the structure. */
	struct weather_record {
		char date[11];
		int high;
		int low;
	};
	
	/* Use typedef to create an alias. */
	typedef struct weather_record wr;
	
	/* Create a structure variable. */
	wr day;
	
	/* Need a pointer of type FILE. */
    FILE *fp;
	
	/* Attempt to open the file for binary reading. */
	fp = fopen(THEFILE, "rb");
	
	if (fp != NULL) { /* The file is open. */
		
		/* Loop through the entire file, assigning each structure to day. */
		while (fread (&day, sizeof (wr), 1, fp)) {
			
			/* Print the information, using the structure's fields. */
			printf ("Date: %s\nHigh: %d\nLow: %d\n\n", day.date, day.high, day.low);
			
		}
		
	} else {
		printf ("The file could not be opened.\n");
		return 1; /* Exit the function/application. */
	}

	/* Close the file. */
	if (fclose(fp) != 0) {
		printf ("The file could not be closed.\n");
	}


	getchar(); /* Pause. */
	return 0;

}