<?php 

// getEmployees.php
// From the book "Effortless Flex 4 Development" by Larry Ullman
// Used in Chapter 8.
// This script returns all of the employees as XML.
// This script may only return the employees in a given department, if a departmentId value is passed in $_GET.

// Send the content-type header:
header('Content-Type: text/xml');

// Start the XML:
echo '<?xml version="1.0" encoding="utf-8" ?>
<employees>
';

// Include the database information script:
require_once('mysql.inc.php');

// Connect to the database:
$dbc = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

// If a connection was established, run the query:
if ($dbc) { 

	// Define the query:
	$q = 'SELECT employees.*, departments.name AS departmentName FROM employees, departments WHERE employees.departmentId = departments.id';

	// Add another conditional if the departmentId was passed to this script:
	if (isset($_GET['departmentId']) && ( ((int)$_GET['departmentId']) > 0 ) ) {
		$q .= ' AND employees.departmentId = ' . (int) $_GET['departmentId'];
	}

	// Run the query:
	$r = mysqli_query($dbc, $q);
	
	// Confirm that some rows were returned:
	if (mysqli_num_rows($r) > 0) {
	
		// Fetch every row and print it as XML:
		while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {
			      echo "<employee>
			<id>{$row['id']}</id>
			<firstName>{$row['firstName']}</firstName>
			<lastName>{$row['lastName']}</lastName>
			<email>{$row['email']}</email>
			<phoneExt>{$row['phoneExt']}</phoneExt>
			<hireDate>{$row['hireDate']}</hireDate>
			<departmentName>{$row['departmentName']}</departmentName>
	</employee>
	";
		} // End of WHILE loop.

	} // End of mysqli_num_rows() IF.

} // End of $dbc IF.

// Complete the XML:
echo '</employees>';

?>