<?php

// ProductsService.php (first version)
// From the book "Effortless Flex 4 Development" by Larry Ullman
// Used in Chapter 9.
// This script defines a class that provides CRUD functionality for the products table.
// This script will be used for the server side of AMF communication.

// Include the database information script:
require_once('mysql.inc.php');

// Define the class:
class ProductsService {

	// Database connection:
	private $dbc;
	
	// Constructor connects to the database:
	public function __construct() {
		$this->dbc = @mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
	}
	
	// The getAllProducts() method returns every product.
	public function getAllProducts() {
	
		// Initialize an array:
		$data = array();
		
		// Query the database:
		$q = 'SELECT * FROM products';
		$r = mysqli_query($this->dbc, $q);
		
		// If rows were returned, fetch them:
		if (mysqli_num_rows($r) > 0) {	
			while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {
				$data[] = $row;
			}
		}

		// Return the retrieved data:
		return $data;

	} // End of getAllProducts() method.
	
	// The createProduct() method creates a single product.
	// It takes one argument, an associative array with these elements: name, price, and inStock (0/1).
	// It returns the new record's PK if the insert worked.
	// It returns nothing if the insert failed.
	public function createProduct($item){
	
		// Sanctify the data:
		$name = mysqli_real_escape_string($this->dbc, trim($item['name']));
		$price = (float) $item['price'];
		$inStock = (int) $item['inStock'];
		
		// Run the query:
		$q = "INSERT INTO products VALUES (null, '$name', $price, $inStock)";
		$r = mysqli_query($this->dbc, $q);
		
		// If one row was affected, return the new primary key:
		if (mysqli_affected_rows($this->dbc) == 1) {
			return mysqli_insert_id($this->dbc);
		}
		
		// If a problem occurred, return nothing:
		return null;
		
	} // End of createProduct() method.
	
	// The updateProduct() method updates a single product.
	// It takes one argument, an associative array with these elements: id, name, price, and inStock (0/1).
	// It returns a Boolean value indicating success.
	public function updateProduct($item) {
		
		// Sanctify the data:
		$id = (int) $item['id'];
		$name = mysqli_real_escape_string($this->dbc, trim($item['name']));
		$price = (float) $item['price'];
		$inStock = (int) $item['inStock'];
		
		// Run the query:
		$q = "UPDATE products SET name='$name', price=$price, inStock=$inStock WHERE id=$id";
		$r = mysqli_query($this->dbc, $q);
		
		// If one row was affected, return true:
		if (mysqli_affected_rows($this->dbc) == 1) {
			return true;
		}
			
		// If a problem occurred, return false:
		return false;
		
	} // End of updateProduct() method.
	
	// The deleteProduct() method deletes a single product.
	// It takes the product's PK as its lone argument.
	// It returns a Boolean value indicating success.
	public function deleteProduct($id) {
		
		// Check for a non-zero id:
		$id = (int) $id;
		if ($id > 0) {
			$q = "DELETE FROM products WHERE id=$id";
			$r = mysqli_query($this->dbc, $q);
			
			// If one row was affected, return true:
			if (mysqli_affected_rows($this->dbc) == 1) {
				return true;
			}
		}
		
		// If a problem occurred, return false:
		return false;
		
	} // End of deleteProduct() method.
	
} // End of ProductsService class.

// Omit the closing PHP tag to avoid potential bugs.