
CREATE TABLE departments (
  id tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;


INSERT INTO departments VALUES(1, 'Human Resources');
INSERT INTO departments VALUES(2, 'Marketing');
INSERT INTO departments VALUES(3, 'Accounting');
INSERT INTO departments VALUES(4, 'Research and Development');
INSERT INTO departments VALUES(5, 'Sales');



CREATE TABLE employees (
  id mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  departmentId tinyint(2) unsigned NOT NULL,
  firstName varchar(20) NOT NULL,
  lastName varchar(40) NOT NULL,
  email varchar(60) NOT NULL,
  phoneExt smallint(4) unsigned DEFAULT NULL,
  hireDate date NOT NULL,
  leaveDate date DEFAULT NULL,
  PRIMARY KEY (id),
  KEY `name` (lastName,firstName),
  KEY departmentId (departmentId)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;


INSERT INTO employees VALUES(1, 1, 'Liz', 'Lemon', 'll@example.com', 234, '1992-05-13', NULL);
INSERT INTO employees VALUES(2, 3, 'Jack', 'Donaghy', 'jd@example.com', 130, '1999-02-24', NULL);
INSERT INTO employees VALUES(3, 2, 'Pete', 'Hornberger', 'ph@example.com', 469, '1997-10-28', NULL);
INSERT INTO employees VALUES(4, 2, 'Kenneth', 'Parcell', 'kp@example.com', 100, '2006-08-02', NULL);



CREATE TABLE products (
  id mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  price decimal(7,2) unsigned NOT NULL,
  inStock tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;


INSERT INTO products VALUES(1, 'Standard Widget', 19.95, 1);
INSERT INTO products VALUES(2, 'New, Improved Widget', 29.95, 1);
INSERT INTO products VALUES(3, 'Deluxe Widget', 49.95, 1);
INSERT INTO products VALUES(4, 'Super Deluxe Widget', 99.95, 0);
INSERT INTO products VALUES(5, 'Overpriced Widget', 199.95, 1);
