<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
	<title>Edit An Expense</title>
</head>
<body>
<?php

// ***** edit_expense.php *****
// ***** Script 7.6 *****
// This page displays and handles a form for 
// editing records in the expenses table.
// This page requires receipt of an eid (expense_id).

// Include the MySQL information:
require_once ('../mysqli_connect2.inc.php');

if (isset($_POST['submitted'])) { // If the form has been submitted, handle it.

	// Check the required form fields:
	if ( (isset($_POST['expense_category_id']) OR !empty($_POST['expense_category'])) AND !empty($_POST['expense_amount']) AND !empty($_POST['expense_description']) ) {	

		// Start the query:
		$q = "UPDATE expenses SET ";
		
		// Determine if a new expense category was entered:
		if (!empty($_POST['expense_category'])) {

			// Create a second query:
			$q2 = "INSERT INTO expense_categories VALUES (NULL, '" . mysqli_real_escape_string ($dbc, $_POST['expense_category']) . "')";
	
			// Execute the second query and react accordingly:
			$r = @mysqli_query ($dbc, $q2);
			if (@mysqli_affected_rows($r) == 1) {
				echo '<b><font color="green">The new expense category has been added!</font></b><br />';
				$q .= "expense_category_id=" . mysqli_insert_id($dbc) . ", ";
			} else {
				echo '<b><font color="red">The new expense category was not entered into the table!</font></b><br />';
				echo '<b><font color="red">MySQL reported: '. mysqli_error($dbc) .'</font></b><br />';
				$problem = TRUE;
			}
			
		} else { // Finish the expense_category conditional.
			$q .= "expense_category_id=" . (int) $_POST['expense_category_id'] . ', ';
		}
		
		// Finish the query:
		$q .= "expense_amount=" . (float) $_POST['expense_amount'] . ", expense_description='" . mysqli_real_escape_string($dbc, $_POST['expense_description']) . "', expense_date='" . mysqli_real_escape_string($dbc, $_POST['expense_date']) . "' WHERE expense_id=" . (int) $_POST['expense_id'];

		// Check to see if there was a problem:
		if (!$problem) {
		
			// Execute the query:
			$r = @mysqli_query ($dbc, $q);
		
			// Print a message indicating success or not:
			if (@mysqli_affected_rows($dbc) == 1) {
				echo '<b><font color="green">The expense has been edited!</font></b>';
			} else {
				echo '<b><font color="red">The expense was not edited!</font></b>';
				echo '<b><font color="red">MySQL reported: '. mysqli_error($dbc) .'</font></b><br />';
			}
		} else { // If there was a problem:
			echo '<b><font color="red">The expense was not edited because the new expense category could not be added!</font></b>';
		}
		
	} else { // Print a message if they failed to enter a required field:
		echo '<b><font color="red">You missed a required field!</font></b>';
	}
	
} else { // If the form has not been submitted, display it.

	// Create the query:
	$q = 'SELECT * FROM expenses WHERE expense_id = ' . (int) $_GET['eid'] . ' LIMIT 1';

	// Execute the query:
	$r = @mysqli_query ($dbc, $q);
	
	// See if an expense was returned:
	if (@mysqli_num_rows($r) == 1) {
		
		// Retrieve and print the results:
		$row = mysqli_fetch_array ($r, MYSQLI_ASSOC);	
		mysqli_free_result($r);
		
		echo 'Edit this expense:<br />
		<form action="edit_expense.php" method="post">	
		<ul>
		<li>Expense Category: <select name="expense_category_id">';
	
		// Display the expense categories:
		$r2 = mysqli_query ($dbc, 'SELECT * FROM expense_categories ORDER BY expense_category');
		while ($row2 = mysqli_fetch_array ($r2, MYSQLI_NUM)) {
			if ($row2[0] == $row['expense_category_id']) {
				echo "<option value=\"$row2[0]\" selected=\"selected\">$row2[1]</option>\n";
			} else {
				echo "<option value=\"$row2[0]\">$row2[1]</option>\n";
			}
		}
		
		mysqli_free_result($r2);
		
		// Finish the form:
		echo '</select></li>
		or<br />
		<li>Enter a new expense category: <input type="text" name="expense_category" size="30" maxlength="30" /></li>
		</ul>
		<p>Expense Amount: <input type="text" name="expense_amount" value="' . $row['expense_amount'] . '" size="10" maxlength="10" /></p>
		<p>Expense Date: <input type="text" name="expense_date" value="' . $row['expense_date'] . '" size="10" maxlength="10" /></p>
		<p>Expense Description: <textarea name="expense_description" rows="5" cols="40">' . $row['expense_description'] . '</textarea></p>
		<input type="hidden" name="submitted" value="true" />
		<input type="submit" name="submit" value="Submit!" />
		<input type="hidden" name="expense_id" value="' . $_GET['eid'] . '" />
		</form>';
	
	} else { // No record returned!
		echo '<b><font color="red">This page must receive a valid expense ID!</font></b>';
	}

} // Finish the main "submit" conditional.

// Close the connection (not required):
mysqli_close($dbc);

?>
</body>
</html>
