#!/usr/bin/perl -w

# Script 8.3, 'show_tables.pl'
# This script takes a database name as 
# a command line argument and shows
# the tables in that database.

# Use what needs to be used.
use strict;
use DBI;

# This script takes one argument when invoked.
# The argument is a database name.
my $database = $ARGV[0];

if (defined($database)) {

	# Connect to the database.
	my $dbh = DBI->connect("DBI:mysql:$database:localhost", 'username', 'password', {RaiseError => 1});
	
	# Query the database.
	my $sth = $dbh->prepare('SHOW TABLES');
	
	if (defined($sth)) {
		$sth->execute();
		my @row;
		while (@row = $sth->fetchrow_array()) {
			print "$row[0]\n";
		}
	}
	$sth->finish();
	
	# Disconnect.
	$dbh->disconnect;
	
} else {
	print "Please enter a database name when calling this script! \n";
}
