#!/usr/bin/perl -w

# Script 8.4 - add_user.pl
# This script adds a user to the logins table.
# It relies upon user input.

# Use what needs to be used.
use strict;
use DBI;

# Print a message.
print "Use this program to add a new login account.\n\n";
print "Client Name (Client ID):\n";

# Connect to the database.
my $dbh = DBI->connect("DBI:mysql:accounting:localhost", 'username', 'password', {RaiseError => 1});

# Show the current clients with their IDs.
my $sql = "SELECT client_name, client_id FROM clients ORDER BY client_name ASC";

# Query the database.
my $sth = $dbh->prepare($sql);

if (defined($sth)) {
	$sth->execute();
	my @row;
	while (@row = $sth->fetchrow_array()) {
		print "$row[0] ($row[1])\n";
	}
}
$sth->finish();

# Get the information from the user.
print "Enter the client ID: ";
my $client_id = <STDIN>;
print "Enter the login username: ";
my $name = <STDIN>;
print "Enter the login password: ";
my $pass1 = <STDIN>;
print "Confirm the login password: ";
my $pass2 = <STDIN>;

# Make sure the passwords match.
while ($pass1 ne $pass2) {
	print "The passwords you entered did not match! Try again!\n";
	
	# Re-request the password.
	print "Enter the login password: ";
	$pass1 = <STDIN>;
	print "Confirm the login password: ";
	$pass2 = <STDIN>;
	
} # End of WHILE loop.

# Query the database.
$sql = "INSERT INTO logins (client_id, login_name, login_pass) VALUES ($client_id, AES_ENCRYPT('$name', 'w1cKet'), SHA1('$pass1'))";
my $affected = $dbh->do($sql);

# Report on the success of the query attempt.
if ($affected == 1) {
	print "The login account has been added! \n";
} else {
	print "The login account could not be added! \n";
}

# Disconnect.
$dbh->disconnect;
