#!/usr/bin/perl -w

# Script 8.5 - add_invoice.pl
# This script adds an invoice to the invoices table.
# It relies upon user input.

# Use what needs to be used.
use strict;
use DBI;

# Print a message.
print "Use this program to add an invoice.\n\n";
print "Client Name (Client ID):\n";

# Connect to the database.
my $dbh = DBI->connect("DBI:mysql:accounting:localhost", 'username', 'password', {RaiseError => 1});

# Show the current clients with their IDs.
my $sql = "SELECT client_name, client_id FROM clients ORDER BY client_name ASC";

# Query the database.
my $sth = $dbh->prepare($sql);

if (defined($sth)) {
	$sth->execute();
	my @row;
	while (@row = $sth->fetchrow_array()) {
		print "$row[0] ($row[1])\n";
	}
}
$sth->finish();

# Get the information from the user.
print "Enter the client ID: ";
my $client_id = <STDIN>;
print "Enter the invoice amount: ";
my $amount = <STDIN>;
print "Enter the invoice description: ";
my $desc = <STDIN>;

# Query the database.
$sql = "INSERT INTO invoices (client_id, invoice_amount, invoice_description) VALUES ($client_id, $amount, '$desc')";
my $affected = $dbh->do($sql);

# Report on the success of the query attempt.
if ($affected == 1) {
	print "Invoice #" . $dbh->{'mysql_insertid'} . " has been created.\n";
} else {
	print "The invoice could not be created! \n";
}

# Disconnect.
$dbh->disconnect;
