#!/usr/bin/perl -w

# Script 8.6, 'show_tables2.pl'
# This script takes a database name as 
# a command line argument and shows
# the tables in that database.

# Use what needs to be used.
use strict;
use DBI;

# This script takes one argument when invoked.
# The argument is a database name.
my $database = $ARGV[0];

if (defined($database)) {

	# Connect to the database.
	my $dbh = DBI->connect("DBI:mysql:$database:localhost", 'username', 'password', {PrintError => 0, RaiseError => 0});
	
	# Check for errors.
	if (DBI->err()) {
		print "Could not connect to the database! MySQL reported: " . DBI->errstr() . "\n";
		exit(1);
	}
	
	# Query the database.
	my $sth = $dbh->prepare('SHOW TABLES');
	
	if (defined($sth)) {
		$sth->execute();
		
		# Check for errors.
		if ($sth->err()) {
			print "Could not execute the query! MySQL reported: " . $sth->errstr() . "\n";
		} else {
			my @row;
			while (@row = $sth->fetchrow_array()) {
				print "$row[0]\n";
			}
			$sth->finish();
		}
	} else {
		print "Could not prepare the query! MySQL reported: " . $dbh->errstr() . "\n";
	}
	
	# Disconnect.
	$dbh->disconnect;
	
} else {
	print "Please enter a database name when calling this script! \n";
}
