#!/usr/bin/perl -w

# Script 8.7 - add_invoice2.pl
# This script adds an invoice to the invoices table.
# It relies upon user input.

# Use what needs to be used.
use strict;
use DBI;

# Print a message.
print "Use this program to add an invoice.\n\n";
print "Client Name (Client ID):\n";

# Connect to the database.
my $dbh = DBI->connect("DBI:mysql:accounting:localhost", 'username', 'password', {RaiseError => 1});

# Show the current clients with their IDs.
my $sql = "SELECT client_name, client_id FROM clients ORDER BY client_name ASC";

# Query the database.
my $sth = $dbh->prepare($sql);

if (defined($sth)) {

	$sth->execute();
	my @row;
	while (@row = $sth->fetchrow_array()) {
		print "$row[0] ($row[1])\n";
	}
	$sth->finish();

} else { # Print the error.
	print "Error! MySQL said: " . $sth->errstr() . "\n";
}

# Get the information from the user.
my $client_id = 0;
while ($client_id <= 0) {
	print "Enter the client ID: ";
	$client_id = <STDIN>;
}

my $amount = 0;
while ($amount <= 0) {
	print "Enter the invoice amount: ";
	$amount = <STDIN>;
}

print "Enter the invoice description: ";
my $desc = <STDIN>;

# Watch for quotes.
$desc = $dbh->quote($desc);

# Query the database.
$sql = "INSERT INTO invoices (client_id, invoice_amount, invoice_description) VALUES ($client_id, $amount, $desc)";
my $affected = $dbh->do($sql);

# Report on the success of the query attempt.
if ($affected == 1) {
	print "Invoice #" . $dbh->{'mysql_insertid'} . " has been created.\n";
} else {
	print "The invoice could not be created! \n";
	print "Error! MySQL said: " . $sth->errstr() . "\n";
}

# Disconnect.
$dbh->disconnect;
