#!/usr/bin/perl -w

# Script 8.8 - add_categories.pl
# This script adds categories to the expense_categories table.
# It relies upon user input.

# Use what needs to be used.
use strict;
use DBI;

# Print a message.
print "Use this program to add expense categories.\n\n";

# Connect to the database.
my $dbh = DBI->connect("DBI:mysql:accounting:localhost", 'username', 'password', {RaiseError => 1});

# Prepare the query.
my $sth = $dbh->prepare("INSERT INTO expense_categories (expense_category) VALUES (?)");

if (defined($sth)) {

	# Get the first category.
	print "Enter an expense category or enter 'q' to quit: ";
	chop (my $cat = <STDIN>);
	
	while ($cat ne "q") {
		
		# Execute the query.
		$sth->execute($cat);
		if ($sth->err()) {
			print "The expense category could not be added.\n\n";
			# Print MySQL error, if desired.
			# exit() ?
		} else {
			print "The expense category has been added.\n\n";
		}
		
		# Reprompt.
		print "Enter an expense category or enter 'q' to quit: ";
		chop ($cat = <STDIN>);

	}

}

# Disconnect.
$dbh->disconnect;
