import java.sql.*;

// Script 9.1 'Connect.java'

public class Connect {

	public static void main(String argv[]) throws Exception {
	
		// Initialize variables.
		Connection con = null;
		
		try {
		
			// Set the connection URL.
			String url = "jdbc:mysql:///test";
			
			Class.forName("com.mysql.jdbc.Driver").newInstance();

			// Connect.
			con = DriverManager.getConnection(url);

			// Report on the results.
			if (con != null) {
				System.out.println("A database connection has been established!");		
			}

		} catch (Exception e) {
		
			System.out.println("Problem: " + e.toString());
			
		}

		// Clean up.
		finally {
		
			if (con != null) {

				try { 
					con.close(); 
				} catch (Exception e) { 
					System.out.println(e.toString());
				}
				con = null;
			}
		}
		
	} // End of main().
	
} // End of class Connect.
