import java.sql.*;

// Script 9.3 'Select.java'

public class Select {
	
	public static void main(String args[]) throws Exception {

		// Initialize variables.
		Connection con = null;
		Statement stmt = null;
		ResultSet rs = null;
		int id = 0;
		String name = null;
				
		try {
		
			// Connect to MySQL.
			String url = "jdbc:mysql:///accounting";
			Class.forName("com.mysql.jdbc.Driver").newInstance();
			con = DriverManager.getConnection(url, "username", "password");
						
			// Run the query.
			stmt = con.createStatement();
			rs = stmt.executeQuery("SELECT client_id, client_name FROM clients ORDER BY client_name ASC LIMIT 5");
						
			// Fetch the results.
			while (rs.next()) {
				id = rs.getInt(1);
				name = rs.getString("client_name");
				
				System.out.println(id + ": " + name);
			}
		}
		
		// Catch exceptions.
		catch (SQLException e) {
			System.out.println("Problem: " + e.toString());
		}
		
		// Clean up.
		finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					// Do nothing with exception.
				}
				rs = null;
			}
			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					// Do nothing with exception.
				}
				stmt = null;
			}
			if (con != null) {
				try {
					con.close();
				} catch (SQLException e) {
					// Do nothing with exception.
				}
			}
		}
		
	} // End of main().
	
} // End of class Select.
