<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
	<title>Storing Images in MySQL</title>
</head>
<body>
<?php

// ***** store_binary.php *****
// ***** Script 12.1 *****
// This script allows the user to upload an image.
// The image is then stored in the binary.images table.

// Connect to MySQL:
$dbc = @mysqli_connect('localhost', 'username', 'password', 'binary_data') or die ('Could not connect to MySQL: ' . mysqli_connect_error() . '</body></html>');

if (isset($_POST['submitted'])) { // If the form has been submitted...
	
	// Check for an uploaded file:
	if (isset($_FILES['upload'])) {
		
		// Validate the type. Should be jpeg, jpg, gif, or png.
		$allowed = array ('image/gif', 'image/jpeg', 'image/jpg', 'image/pjpeg', 'image/png');
		
		if (in_array($_FILES['upload']['type'], $allowed)) { // OK
		
			// Get the image's size in pixels:
			$image_info = getimagesize($_FILES['upload']['tmp_name']);

			// Read the uploaded file into a variable:
			$image = fread(fopen($_FILES['upload']['tmp_name'], 'r'), $_FILES['upload']['size']);
			
			// Secure the data:
			$image = mysqli_real_escape_string($dbc, $image);
			$name = mysqli_real_escape_string($dbc, $_FILES['upload']['name']);
			$size = (int)$_FILES['upload']['size'];
			
			// Generate the query: 
			$q = "INSERT INTO images (image, image_name, image_type, image_width, image_height, image_size) VALUES ('$image', '$name', '{$_FILES['upload']['type']}', $image_info[0], $image_info[1], $size)";
			
			// Execute the query:
			$r = mysqli_query ($dbc, $q);

			// Print a message indicating success:
			if (mysqli_affected_rows($dbc) == 1) {
				echo '<p><font color="green">The image has been stored!</font></p>';
			} else {
				echo '<p><font color="red">The image could not be stored in the database!</font></p>';
				echo '<p><font color="red">MySQL reported: '. mysqli_error($dbc) .'</font></p>';
			}
			
		} else { // Invalid type.
			echo '<p><font color="red">Please upload a JPEG, GIF, or PNG image.</font></p>';
		}

		// Remove the file from the server:
		if (file_exists($_FILES['upload']['tmp_name']) and is_file($_FILES['upload']['tmp_name'])) {
			unlink ($_FILES['upload']['tmp_name']);
		}
			
	} else { // No file uploaded.
		echo '<p><font color="red">Please upload a JPEG, GIF, or PNG image smaller than 512KB.</font></p>';
	}

} // End of submitted IF.

// Display the form:
echo '<h2>Use this form to store an image in the database:</h2>
<p>(Images must be of type JPEG, GIF, or PNG.)</p>
<form action="store_binary.php" method="post" enctype="multipart/form-data">
<input type="hidden" name="MAX_FILE_SIZE" value="524288" />
<p>Select an image to upload: <input type="file" name="upload" /></p>
<input type="hidden" name="submitted" value="true" />
<input type="submit" name="submit" value="Submit!" />
</form>
<br />';


// Show the current list of images.
// Link each to view_image.php.
echo '<h2>Currently Stored Images</h2><p>(Click an image\'s name to view it.)</p>';

// Create the query:
$q = 'SELECT image_id, image_name FROM images ORDER BY uploaded_date DESC';

// Execute the query:
$r = mysqli_query ($dbc, $q);

// Check the results:
if (mysqli_num_rows($r) > 0) {

	// Display each item in a list.
	echo '<ul>';

	while ($row = mysqli_fetch_array ($r, MYSQLI_NUM)) {
		echo "<li><a href=\"view_image.php?i=$row[0]\">$row[1]</a></li>\n";
	}

	echo '<ul>';

	// Clean up:
	mysqli_free_result($r);
	
} else { // No records returned.
	echo '<p>There are currently no stored images.</p>';
}

// Close the database connection:
mysqli_close($dbc);

?>
</body>
</html>
