<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
	<title>Browse the Movie Titles</title>
</head>
<body>
<?php

// ***** browse_movies.php *****
// ***** Script 12.3 *****
// This script generates query result pages 
// of movie titles in the movies database.
	
// Number of records to show per page:
$display_number = 5;

// Connect to MySQL:
$dbc = @mysqli_connect('localhost', 'username', 'password', 'movies') or die ('Could not connect to MySQL: ' . mysqli_connect_error() . '</body></html>');

// Determine how many records there are: 
if (isset($_GET['np'])) {

	$num_pages = (int) $_GET['np'];
	
} else {

	// Find out how many records there are.
	$q = 'SELECT COUNT(*) FROM directors, films WHERE directors.director_id=films.director_id';
	
	// Get the number.
	$r = mysqli_query($dbc, $q);
	list($num_records) = mysqli_fetch_array($r, MYSQLI_NUM);
	mysqli_free_result($r);
	
	// Calculate the number of pages:
	if ($num_records > $display_number) {
		$num_pages = ceil ($num_records/$display_number);
	} else {
		$num_pages = 1;
	}
	
}

// Determine where in the database to start returning results:
if (isset($_GET['s'])) {
	$start = (int) $_GET['s'];
} else {
	$start = 0;
}

// Define the query:
$q = "SELECT CONCAT(directors.first_name, ' ', directors.last_name) AS Director, title AS Title FROM directors, films WHERE directors.director_id=films.director_id ORDER BY films.title ASC LIMIT $start, $display_number";

// Run the query:
$r = mysqli_query ($dbc, $q);

// Display all of the records:
while ($row = mysqli_fetch_array ($r, MYSQLI_ASSOC)) {
	echo "{$row['Director']} <i>{$row['Title']}</i><br />\n";
}

// Clean up:
mysqli_free_result ($r);
mysqli_close($dbc);

// Make the links to other pages, if necessary:
if ($num_pages > 1) {

	echo '<hr width="50%" align="left" />';
		
	// Determine what page the script is on:	
	$current_page = ($start/$display_number) + 1;
	
	// If it's not the first page, make a Previous button:
	if ($current_page != 1) {
		echo '<a href="browse_movies.php?s=' . ($start - $display_number) . '&np=' . $num_pages . '">Previous</a> ';
	}
	
	// Make all the numbered pages:
	for ($i = 1; $i <= $num_pages; $i++) {
	
		// Don't link the current page:
		if ($i != $current_page) {
			echo '<a href="browse_movies.php?s=' . (($display_number * ($i - 1))) . '&np=' . $num_pages . '">' . $i . '</a> ';
		} else {
			echo $i . ' ';
		}
		
	}
	
	// If it's not the last page, make a Next button:
	if ($current_page != $num_pages) {
		echo '<a href="browse_movies.php?s=' . ($start + $display_number) . '&np=' . $num_pages . '">Next</a> ';
	}
	
}

?>
</body>
</html>
