#!/usr/bin/perl -w

# Script 12.4 - transfer_money.pl
# This script lets a user transfer money
# from one account to another.

# Use what needs to be used.
use strict;
use DBI;

# Needed variables:
my ($dbh, $sql, $sth, @row, $balance, $affected, $from, $to, $amount);

# Print a message.
print "Use this program to transfer money.\n\n";
print "Accounts (Account ID):\n";

# Connect to the database.
$dbh = DBI->connect("DBI:mysql:test:localhost", 'username', 'password', {RaiseError => 1});

# Show the current accounts with their IDs.
$sql = "SELECT CONCAT(last_name, ', ', first_name) AS name, id FROM accounts ORDER BY last_name, first_name ASC";
$sth = $dbh->prepare($sql);
$sth->execute();
while (@row = $sth->fetchrow_array()) {
	print "$row[0] ($row[1])\n";
}
$sth->finish();

# Get the information from the user.
print "\nFROM whose account is the money being transferred? ";
$from = <STDIN>;
print "\nINTO whose account is the money being transferred? ";
$to = <STDIN>;
print "\nHOW MUCH money is being transferred? ";
$amount = <STDIN>;

# Validate the input (omitted).

# Confirm that the FROM account can afford the transfer.
$sql = "SELECT balance FROM accounts WHERE id=$from";
$sth = $dbh->prepare($sql);
$sth->execute();
$balance = $sth->fetchrow_array();
$sth->finish();
	
# Can they afford it?
if ($balance >= $amount) { # Transact!

	# Start the transaction.
	$dbh->{'AutoCommit'} = 0;	

	# Subtract the amount.
	$affected = $dbh->do("UPDATE accounts SET balance=(balance - $amount) WHERE id=$from");
	if ($affected == 1) { # Good!

		# Add the amount.
		$affected = $dbh->do("UPDATE accounts SET balance=(balance + $amount) WHERE id=$to");
		if ($affected == 1) { # Commit.
		
			$dbh->commit();
			print "\nThe transaction is complete! \n";
			
		} else { # Rollback.
		
			$dbh->rollback();
			print "\nAn error occurred! The transaction was rolled back. \n";
			
		}
			
	} else { # First UPDATE didn't work.
		
		# Cancel the transaction.
		$dbh->rollback();
		
		print "\nAn error occurred! The transaction was rolled back. \n";
			
	}

} else { # Can't afford it!
	print "\nNon-sufficient Funds! \n";
}

# Disconnect.
$dbh->disconnect;
