import java.sql.*;

// Script 8.3 'Select.java'

public class Select {
	
	public static void main(String args[]) throws Exception {
		Connection con = null;
		Statement stmt = null;
		ResultSet rs = null;
				
		try {
			String url = "jdbc:mysql:///accounting";
			Class.forName("org.gjt.mm.mysql.Driver");
			con = DriverManager.getConnection(url, "testing", "password");
						
			stmt = con.createStatement();
			rs = stmt.executeQuery("SELECT client_id, client_name FROM clients LIMIT 5");
						
			while (rs.next()) {
				int key = rs.getInt(1);
				String value = rs.getString("client_name");
				
				System.out.println(key + ": " + value + "\n");
			}
		}
		
		catch (SQLException e) {
			e.printStackTrace();
		}
		
		finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
			if (con != null) {
				try {
					con.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}
	}
}
