#!/usr/bin/perl

# Script 9.5, 'search_movies2.pl'

# Use what needs to be used.
use DBI;
use strict;

# Connect to the database.
my $user;
my $password;
my $dbh = DBI->connect('DBI:mysql:movies_db;mysql_read_default_file=/Users/lullman/.my.cnf', $user, $password, {RaiseError => 1});

# If a connection was made, run the query.
if ($dbh) {

	# Get the keywords.
	print "Enter a keyword to be searched: ";
	my $term1 = <STDIN>;
	print "Enter a second keyword to be searched: ";
	my $term2 = <STDIN>;

	# Create the SQL statement.
	my $sql = "SELECT CONCAT(directors.first_name, ' ', directors.last_name) AS Director, title AS Title FROM directors, movies WHERE directors.director_id=movies.director_id";

	# Add the keywords to the SQL statement.	
	if (length($term1) > 1) {
		chop($term1);
		$term1 =~ s/'/\\'/;
		$sql .= " AND ( (directors.last_name LIKE '%$term1%' OR directors.first_name LIKE '%$term1%' OR movies.title LIKE '%$term1%')"; 

		if (length($term2) > 1) {
			chop($term2);
			$term2 =~ s/'/\\'/;
			$sql .= " AND (directors.last_name LIKE '%$term2%' OR directors.first_name LIKE '%$term2%' OR movies.title LIKE '%$term2%')"; 
		}
		
		$sql .= ")";
	}
	
	# Run the query.
	my $query = $dbh->prepare ($sql);
	my @row;
	my $n;
	if (defined($query)) {
		print "\n";
		$query->execute();
		for ($n=0; $n < $query->{'NUM_OF_FIELDS'}; $n++) {
			print @{$query->{'NAME'}}[$n];
			print "\t";
		}
		print "\n";
		while (@row = $query->fetchrow_array()) {
			foreach (@row) {
				print "$_ \t";
			}
			print "\n";
		}
	} else {
		print "The query was not executed because MySQL reported " . DBI->errstr() . ". \n";
	}
	print "\n";
	
	# Close the query and disconnect from the database.
	$query->finish();
	$dbh->disconnect;
	
} else {
	print "Could not connect to the database! \n";
}