# Make the accounting database.
CREATE DATABASE accounting;
USE accounting;

# Make the invoices table.
CREATE TABLE invoices (
invoice_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
client_id SMALLINT(3) UNSIGNED,
invoice_date DATE NOT NULL,
invoice_amount DECIMAL(10,2) UNSIGNED NOT NULL,
invoice_description TINYTEXT,
PRIMARY KEY (invoice_id),
INDEX (invoice_date)
);

# Make the clients table.
CREATE TABLE clients (
client_id SMALLINT(3) UNSIGNED NOT NULL AUTO_INCREMENT,
client_name VARCHAR(40) NOT NULL,
client_street VARCHAR(80),
client_city VARCHAR(30),
client_state CHAR(2),
client_zip MEDIUMINT(5) UNSIGNED,
client_phone VARCHAR(14),
contact_name VARCHAR(40),
contact_email VARCHAR(60),
PRIMARY KEY (client_id),
INDEX (client_name)
);

# Make the expenses table.
CREATE TABLE expenses (
expense_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
expense_category_id TINYINT(3) UNSIGNED,
expense_amount DECIMAL(10,2) UNSIGNED,
expense_description TINYTEXT,
expense_date DATE,
PRIMARY KEY (expense_id)
);

# Make the expense_categories table.
CREATE TABLE expense_categories (
expense_category_id TINYINT(3) UNSIGNED NOT NULL AUTO_INCREMENT,
expense_category VARCHAR(30),
PRIMARY KEY (expense_category_id)
);

# Make alterations.
ALTER TABLE clients CHANGE COLUMN contact_name contact_first_name VARCHAR(15);
ALTER TABLE clients ADD COLUMN contact_last_name VARCHAR(25);