# Populate the clients table.
INSERT INTO clients VALUES (1,'Acme Industries','100 Main Street','Anytown','NY',11111,'(888) 555-1234','Jane','Jane@acme_industries.com','Doe');
INSERT INTO clients VALUES (2,'Winesburg Press',NULL,NULL,NULL,NULL,NULL,'Sherwood Anders',NULL,NULL);
INSERT INTO clients VALUES (3,'Galt on the Hill','1000 Tuttle Drive','Brazilia','IL',60000,NULL,'Joe Bagadonuts','jimmy.johns@usda.fed.gov',NULL);
INSERT INTO clients VALUES (4,'ABC Noun',NULL,NULL,NULL,NULL,NULL,'Clarissa Jones',NULL,NULL);
INSERT INTO clients VALUES (5,'The Enterprises','200 Main Street','Anytown','NY',11111,'(800) 555-5555','John Doe','Johnny_D@theenterprises.com',NULL);
INSERT INTO clients VALUES (6,'Another Client',NULL,NULL,NULL,NULL,NULL,'Art Vanderlay',NULL,NULL);
INSERT INTO clients VALUES (7,'Nepotism Inc.',NULL,NULL,NULL,NULL,NULL,'Joey B.','info@web-address.edu',NULL);
INSERT INTO clients VALUES (8,'Something Clever',NULL,NULL,NULL,NULL,NULL,'Daryl Zero',NULL,NULL);
INSERT INTO clients VALUES (9,'MiddleEarth Software',NULL,NULL,NULL,NULL,NULL,'Rebecca',NULL,'Kniest');

# Populate the expense_categories table.
INSERT INTO expense_categories VALUES (22,'Magazine Subscriptions');
INSERT INTO expense_categories VALUES (3,'Books');
INSERT INTO expense_categories VALUES (4,'Web Hosting');
INSERT INTO expense_categories VALUES (5,'Computer Software');
INSERT INTO expense_categories VALUES (6,'Computer Hardware');
INSERT INTO expense_categories VALUES (7,'Sand Paper');
INSERT INTO expense_categories VALUES (8,'Drum Sanders');
INSERT INTO expense_categories VALUES (9,'Plaster of Paris');
INSERT INTO expense_categories VALUES (10,'Erasers');
INSERT INTO expense_categories VALUES (11,'Sandals');
INSERT INTO expense_categories VALUES (12,'Horseshoes');
INSERT INTO expense_categories VALUES (13,'Drywall');
INSERT INTO expense_categories VALUES (14,'Paper Clips');
INSERT INTO expense_categories VALUES (15,'Eggs');
INSERT INTO expense_categories VALUES (16,'Light Switches');
INSERT INTO expense_categories VALUES (17,'Electricity');
INSERT INTO expense_categories VALUES (21,'Travel');
INSERT INTO expense_categories VALUES (19,'Print Cartridges');
INSERT INTO expense_categories VALUES (20,'Picture Frames');
INSERT INTO expense_categories VALUES (23,'Internet Access Fees');
INSERT INTO expense_categories VALUES (24,'Pencils');
INSERT INTO expense_categories VALUES (25,'Employee Benefits');
# --------------------------------------------------------

#
# Table structure for table `expenses`
#

DROP TABLE IF EXISTS expenses;
CREATE TABLE expenses (
  expense_id smallint(4) unsigned NOT NULL auto_increment,
  expense_category_id tinyint(3) unsigned default NULL,
  expense_amount decimal(10,2) unsigned default NULL,
  expense_description tinytext,
  expense_date date default NULL,
  PRIMARY KEY  (expense_id),
  FULLTEXT KEY expense_description (expense_description)
) TYPE=MyISAM;

#
# Dumping data for table `expenses`
#

INSERT INTO expenses VALUES (1,3,'19.99','Larry Ullman\'s "MySQL: Visual QuickStart Guide"','2002-04-20');
INSERT INTO expenses VALUES (2,21,'104.50','Palmer House Hotel, Chicago','2002-01-26');
INSERT INTO expenses VALUES (3,21,'689.00','Flight to Chicago','2002-01-26');
INSERT INTO expenses VALUES (4,5,'99.99','Mmmm...software','2002-01-12');
INSERT INTO expenses VALUES (5,21,'64.99','Flight from Chicago','2002-04-20');
INSERT INTO expenses VALUES (6,6,'64.50','Apple Titanium PowerBook','0000-00-00');
INSERT INTO expenses VALUES (7,8,'6464.00','Sculpting','2002-01-26');
INSERT INTO expenses VALUES (8,24,'67.94','Writing implements needed to fill in little bubbles on tests.','2002-04-20');
INSERT INTO expenses VALUES (9,12,'1.97','Reconstruction','2002-04-20');
INSERT INTO expenses VALUES (10,7,'3216.00','Sanding','2002-01-26');
INSERT INTO expenses VALUES (11,7,'9712.97','There\'s a lot of sanding to do.','2002-01-26');
INSERT INTO expenses VALUES (12,4,'312.64','Software upgrade.',NULL);
INSERT INTO expenses VALUES (13,20,'25.00','Frame to display Jess\\\' diploma.','2002-05-09');
INSERT INTO expenses VALUES (14,23,'39.99','Monthly expense for cable modem Internet access.','2002-05-09');
INSERT INTO expenses VALUES (15,3,'19.99','Larry Ullman\\\'s \\"PHP for the World Wide Web: Visual QuickStart Guide\\".','2002-05-09');
INSERT INTO expenses VALUES (16,3,'29.99','Larry Ullman\'s "PHP Advanced for the World Wide Web: Visual QuickPro Guide"','2002-05-24');
INSERT INTO expenses VALUES (17,5,'129.00','Software to create visual representations of databases.','2002-05-24');
# --------------------------------------------------------

#
# Table structure for table `invoices`
#

DROP TABLE IF EXISTS invoices;
CREATE TABLE invoices (
  invoice_id smallint(4) unsigned NOT NULL auto_increment,
  client_id smallint(3) unsigned default NULL,
  invoice_date date NOT NULL default '0000-00-00',
  invoice_amount decimal(10,2) unsigned NOT NULL default '0.00',
  invoice_description tinytext,
  PRIMARY KEY  (invoice_id),
  KEY invoice_date (invoice_date)
) TYPE=MyISAM;

#
# Dumping data for table `invoices`
#

INSERT INTO invoices VALUES (1,4,'2002-04-24','1902.34','Conjugation: verbs, nouns, adjectives.');
INSERT INTO invoices VALUES (2,4,'2004-07-20','942.00','Technical writing.');
INSERT INTO invoices VALUES (3,2,'2003-07-20','54.25','Hand wringing');
INSERT INTO invoices VALUES (4,3,'2002-04-24','1.00','Miscellaneous Services');
INSERT INTO invoices VALUES (5,1,'2002-04-10','654.34','Work, work, work.');
INSERT INTO invoices VALUES (6,1,'2004-01-20','98754.00','Technical writing.');
INSERT INTO invoices VALUES (7,2,'2003-07-18','54.25','Pacing.');
INSERT INTO invoices VALUES (8,3,'2002-04-24','3210.84','Pondering');
INSERT INTO invoices VALUES (9,4,'2003-04-08','6.64','Shady dealings.');
INSERT INTO invoices VALUES (10,4,'2004-11-20','2.00','Brilliance.');
INSERT INTO invoices VALUES (11,5,'2001-07-03','9.96','Don\'t ask.');
INSERT INTO invoices VALUES (12,2,'2002-04-22','315.94','Miscellaneous Services');
INSERT INTO invoices VALUES (13,3,'2002-12-24','9751.94','Reading.');
INSERT INTO invoices VALUES (14,4,'2002-07-20','321.55','HTML, PHP, MySQL Web development.');
INSERT INTO invoices VALUES (15,6,'2001-07-27','2.55','Hand wringing');
INSERT INTO invoices VALUES (16,7,'2003-10-24','64.64','Miscellaneous Services');
# --------------------------------------------------------

#
# Table structure for table `users`
#

DROP TABLE IF EXISTS users;
CREATE TABLE users (
  user_id int(10) unsigned NOT NULL auto_increment,
  user_pass varchar(16) default NULL,
  user_name tinyblob,
  PRIMARY KEY  (user_id)
) TYPE=MyISAM;
