# SQL Commands from "PHP and MySQL for Dynamic Web Sites: Visual QuickPro Guide (2nd Edition)"
# Written by Larry Ullman, Published May 2005

# This file contains the CREATE, INSERT, and ALTER SQL statements used in the book, listed by chapter.
# The SQL commands here are from the steps where they are entered into the MySQL monitor.
# SQL commands from the tips and from the PHP scripts are not included.
# You SHOULD NOT attempt to run this file in MySQL as is. Cut and paste the specific commands as needed.
# Some later table creation commands are preceeded by a DROP TABLE command. This will delete an existing table and ALL DATA.

# ---------
# Chapter 4
# ---------
CREATE DATABASE sitename;

USE sitename;

CREATE TABLE users (
user_id MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,
first_name VARCHAR(15) NOT NULL,
last_name VARCHAR(30) NOT NULL,
email VARCHAR(40) NOT NULL,
password CHAR(40) NOT NULL,
registration_date DATETIME NOT NULL,
PRIMARY KEY (user_id)
);

INSERT INTO users (first_name, last_name, email, password, registration_date) VALUES ('Larry', 'Ullman', 'phpmysql2@DMCInsights.com', SHA('password'), NOW());

INSERT INTO users VALUES (NULL, 'Larry', 'Ullman', 'phpmysql2@DMCInsights.com', SHA('password'), NOW());

INSERT INTO users (first_name, last_name, email, password, registration_date) VALUES
('John', 'Lennon', 'john@beatles.com', SHA('Happin3ss'), NOW()),
('Paul', 'McCartney', 'paul@beatles.com', SHA('letITbe'), NOW()),
('George', 'Harrison', 'george@beatles.com ', SHA('something'), NOW()),
('Ringo', 'Starr', 'ringo@beatles.com', SHA('thisboy'), NOW());

INSERT INTO users (first_name, last_name, email, password, registration_date) VALUES
('David', 'Jones', 'davey@monkees.com', SHA('fasfd'), NOW()),
('Peter', 'Tork', 'peter@monkees.com', SHA('warw'), NOW()),
('Micky', 'Dolenz', 'micky@monkees.com ', SHA('afsa'), NOW()),
('Mike', 'Nesmith', 'mike@monkees.com', SHA('abdfadf'), NOW()),
('David', 'Sedaris', 'david@authors.com', SHA('adfwrq'), NOW()),
('Nick', 'Hornby', 'nick@authors.com', SHA('jk78'), NOW()),
('Melissa', 'Bank', 'melissa@authors.com', SHA('jhk,h'), NOW()),
('Toni', 'Morrison', 'toni@authors.com', SHA('hdhd'), NOW()),
('Jonathan', 'Franzen', 'jonathan@authors.com', SHA('64654'), NOW()),
('Don', 'DeLillo', 'don@authors.com', SHA('asf8'), NOW()),
('Graham', 'Greene', 'graham@authors.com', SHA('5684eq'), NOW()),
('Michael', 'Chabon', 'michael@authors.com', SHA('srw6'), NOW()),
('Richard', 'Brautigan', 'richard@authors.com', SHA('zfs654'), NOW()),
('Russell', 'Banks', 'russell@authors.com', SHA('wwr321'), NOW()),
('Homer', 'Simpson', 'homer@simpson.com', SHA('5srw651'), NOW()),
('Marge', 'Simpson', 'marge@simpson.com', SHA('ljsa'), NOW()),
('Bart', 'Simpson', 'bart@simpson.com', SHA('pwqojz'), NOW()),
('Lisa', 'Simpson', 'lisa@simpson.com', SHA('uh6'), NOW()),
('Maggie', 'Simpson', 'maggie@simpson.com', SHA('plda664'), NOW()),
('Abe', 'Simpson', 'abe@simpson.com', SHA('qopkrokr65'), NOW());

# ---------
# Chapter 5
# ---------

CREATE DATABASE content;
USE content;

CREATE TABLE urls (
url_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
url VARCHAR(60) NOT NULL,
title VARCHAR(60) NOT NULL,
description TINYTEXT NOT NULL,
PRIMARY KEY (url_id)
);

CREATE TABLE url_categories (
url_category_id TINYINT(3) UNSIGNED NOT NULL AUTO_INCREMENT,
category VARCHAR(20) NOT NULL,
PRIMARY KEY (url_category_id)
);

CREATE TABLE url_associations (
ua_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
url_id SMALLINT(4) UNSIGNED NOT NULL,
url_category_id TINYINT(3) UNSIGNED NOT NULL,
date_submitted TIMESTAMP,
approved CHAR(1) DEFAULT 'N' NOT NULL,
PRIMARY KEY (ua_id)
);

INSERT INTO url_categories (category) VALUES ('General PHP'), ('Web Development'), ('Code Libraries'), ('Programming'), ('General MySQL'), ('General Database');

INSERT INTO urls (url, title, description) VALUES
('www.php.net', 'PHP: Hypertext Preprocessor', 'The home page of PHP...'),
('www.mysql.com', 'MySQL: The World\'s Most Popular Open Source Database', 'The home page of MySQL...'),
('www.w3.org', 'World Wide Web Consortium', 'The home page of the W3C...'),
('www.Zend.com', 'Zend', 'The home page of Zend...');

INSERT INTO url_associations
(url_id, url_category_id, approved)
VALUES
(1,1,'Y'),
(1,4,'Y'),
(1,2,'Y'),
(2,5,'Y'),
(2,2,'Y'),
(3,2,'Y'),
(4,1,'Y'),
(4,3,'Y');

ALTER TABLE url_categories ADD UNIQUE(category);
ALTER TABLE urls ADD UNIQUE(url);
ALTER TABLE url_associations ADD INDEX (url_id), ADD INDEX (url_category_id), ADD INDEX (date_submitted);

ALTER TABLE urls ENGINE=MYISAM;

ALTER TABLE urls ADD FULLTEXT INDEX (description);

# ---------
# Chapter 10
# ---------

USE test;

CREATE TABLE comments (
	comment_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
	name VARCHAR(60) NOT NULL,
	comment TEXT NOT NULL,
	stamp CHAR(32) NOT NULL,
	date_entered TIMESTAMP,
	PRIMARY KEY (comment_id),
	UNIQUE (stamp)
);

CREATE TABLE encode (
id INT UNSIGNED NOT NULL AUTO_INCREMENT,
card_number TINYBLOB,
PRIMARY KEY (id)
);

INSERT INTO encode (id, card_number) VALUES (NULL, ENCODE(1234567890123456, 'eLL10tT'));

TRUNCATE TABLE encode;

CREATE TABLE aes_salt (
	salt VARCHAR(12) NOT NULL
);
INSERT INTO aes_salt (salt) VALUES ('0bfuscate');

SELECT @salt:=salt FROM aes_salt;
INSERT INTO encode (card_number) VALUES (AES_ENCRYPT(1234567890123456, @salt));


# ---------
# Chapter 11
# ---------

USE test;

CREATE TABLE accounts (
	id INT UNSIGNED NOT NULL AUTO_INCREMENT,
	name VARCHAR(40) NOT NULL,
	balance DECIMAL(10,2) NOT NULL DEFAULT 0.0,
	PRIMARY KEY (id)
) ENGINE=InnoDB;

INSERT INTO accounts (name, balance) VALUES ('Sarah Vowell', 5460.23), ('David Sedaris', 909325.24), ('Kojo Nnamdi', 892.00);

# ---------
# Chapter 12
# ---------

USE content;
CREATE TABLE uploads (
upload_id int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
file_name VARCHAR(30) NOT NULL,
file_size INT(6) UNSIGNED NOT NULL,
file_type VARCHAR(30) NOT NULL,
description VARCHAR(100) DEFAULT NULL,
date_entered TIMESTAMP,
PRIMARY KEY (upload_id),
KEY (file_name),
KEY (date_entered)
)
CREATE TABLE urls (
url_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
url VARCHAR(60) NOT NULL,
title VARCHAR(60) NOT NULL,
description TINYTEXT NOT NULL,
PRIMARY KEY (url_id)
)
CREATE TABLE url_categories (
url_category_id TINYINT(3) UNSIGNED NOT NULL AUTO_INCREMENT,
category VARCHAR(20) NOT NULL,
PRIMARY KEY (url_category_id)
)
CREATE TABLE url_associations (
ua_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
url_id SMALLINT(4) UNSIGNED NOT NULL,
url_category_id TINYINT(3) UNSIGNED NOT NULL,
date_submitted TIMESTAMP,
approved CHAR(1) DEFAULT 'N' NOT NULL,
PRIMARY KEY (ua_id)
);
CREATE TABLE uploads (
upload_id int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
file_name VARCHAR(30) NOT NULL,
file_size INT(6) UNSIGNED NOT NULL,
file_type VARCHAR(30) NOT NULL,
description VARCHAR(100) DEFAULT NULL,
date_entered TIMESTAMP,
PRIMARY KEY (upload_id),
KEY (file_name),
KEY (date_entered)
);

# ----------
# Chapter 13
# ----------

USE sitename;

DROP TABLE IF EXISTS users;
CREATE TABLE users (
user_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
email VARCHAR(40) NOT NULL,
pass CHAR(40) NOT NULL,
first_name VARCHAR(15) NOT NULL,
last_name VARCHAR(30) NOT NULL,
active CHAR(32),
registration_date DATETIME NOT NULL,
PRIMARY KEY (user_id),
UNIQUE KEY (email),
KEY (email, pass)
);

# ----------
# Chapter 14
# ----------
USE ecommerce;

CREATE TABLE artists (
artist_id INT(3) UNSIGNED NOT NULL
AUTO_INCREMENT,
first_name VARCHAR(20),
middle_name VARCHAR(20),
last_name VARCHAR(30) NOT NULL,
PRIMARY KEY (artist_id),
KEY last_name (last_name),
KEY full_name (last_name, first_name)
);

CREATE TABLE prints (
print_id INT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
artist_id INT(3) UNSIGNED NOT NULL,
print_name VARCHAR(60) NOT NULL,
price decimal(6,2) NOT NULL,
size VARCHAR(60) default NULL,
description VARCHAR(255) default NULL,
image_name VARCHAR(30) default NULL,
PRIMARY KEY (print_id),
KEY artist_id (artist_id),
KEY print_name (print_name)
);

DROP TABLE IF EXISTS customers;
CREATE TABLE customers (
customer_id INT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
username VARCHAR(16) NOT NULL,
password VARCHAR(16) NOT NULL,
card_number TINYBLOB,
PRIMARY KEY (customer_id),
KEY username (username),
KEY password (password),
KEY user_pass (username, password)
);

CREATE TABLE orders (
order_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
customer_id INT(5) UNSIGNED NOT NULL,
total decimal(10,2) UNSIGNED NOT NULL,
order_date datetime NOT NULL,
approved char(1) NOT NULL default 'N',
cart VARCHAR(75) NOT NULL,
PRIMARY KEY (order_id),
KEY customer_id (customer_id),
KEY order_date (order_date)
);

CREATE TABLE order_contents (
oc_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
order_id INT(10) UNSIGNED NOT NULL,
print_id INT(4) UNSIGNED NOT NULL,
quantity TINYINT UNSIGNED NOT NULL DEFAULT 1,
price decimal(6,2) NOT NULL,
ship_date DATETIME default NULL,
PRIMARY KEY (oc_id),
KEY order_id (order_id),
KEY print_id (print_id),
KEY ship_date (ship_date)
) ENGINE=InnoDB;
