<?php # Script 7.11 - logout.php

session_start(); // Access the existing session.

// If no first_name variable exists, redirect the user.
if (!isset($_SESSION['first_name'])) {
	header ("Location:  http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/index.php");
	exit(); // Quit the script.
} else {
	$_SESSION = array(); // Destroy the variables.
	session_destroy(); // Destroy the session itself.
	setcookie ('PHPSESSID', '', time()-300, '/', '', 0); // Destroy the cookie.
}

// Set the page title and include the HTML header.
$page_title = 'Logout!';
include ('templates/header.inc');

// Print a customized message.
echo "<p>You are now logged out.</p>";

include ('templates/footer.inc'); // Include the HTML footer.
?>