<?php # Script 12.15 - view_users.php
// This page allows the administrator to view all of the current users.

// Include the configuration file for error management and such.
require_once ('../includes/config.inc'); 

// Require authentication.
require_once ('../../authentication.php');

// Set the page title and include the HTML header.
$page_title = 'View the Current Users';
include_once ('../includes/admin_header.html');

// Check for authorization.
if (!$authorized) {
	echo '<p><font color="red" size="+1">Please enter a valid username and password! Click <a href="index.php">here</a> to try again!</font></p>';
} else {

	require_once ('../../mysql_connect.php'); // Connect to the database.

	// Number of records to show per page:
	$display = 10;
	
	// Determine how many pages there are. 
	if (isset($_GET['np'])) { // Already been determined.
		$num_pages = $_GET['np'];
	} else { // Need to determine.
		$query = "SELECT CONCAT(last_name, ', ', first_name) AS name, DATE_FORMAT(registration_date, '%M %d, %Y') AS dr FROM users ORDER BY registration_date ASC"; // Standard query.
		$query_result = mysql_query ($query);
		$num_records = @mysql_num_rows ($query_result);
		
		if ($num_records > $display) { // More than 1 page.
			$num_pages = ceil ($num_records/$display);
		} else {
			$num_pages = 1;
		}
	}
	
	// Determine where in the database to start returning results.
	if (isset($_GET['s'])) { // Already been determined.
		$start = $_GET['s'];
	} else {
		$start = 0;
	}
			
	// Make the query.
	$query = "SELECT CONCAT(last_name, ', ', first_name) AS name, DATE_FORMAT(registration_date, '%M %d, %Y') AS dr FROM users ORDER BY registration_date ASC LIMIT $start, $display";		
	$result = @mysql_query ($query); // Run the query.
	$num = mysql_num_rows ($result); // How many users are there?
	
	if ($num > 0) { // If it ran OK, display the records.
	
		echo "<h1>Registered Users</h1>";
	
		// Make the links to other pages, if necessary.
		if ($num_pages > 1) {
			
			echo '<p>';
			// Determine what page the script is on.	
			$current_page = ($start/$display) + 1;
			
			// If it's not the first page, make a Previous button.
			if ($current_page != 1) {
				echo '<a href="view_users.php?s=' . ($start - $display) . '&np=' . $num_pages . '">Previous</a> ';
			}
			
			// Make all the numbered pages.
			for ($i = 1; $i <= $num_pages; $i++) {
				if ($i != $current_page) {
					echo '<a href="view_users.php?s=' . (($display * ($i - 1))) . '&np=' . $num_pages . '">' . $i . '</a> ';
				} else {
					echo $i . ' ';
				}
			}
			
			// If it's not the last page, make a Next button.
			if ($current_page != $num_pages) {
				echo '<a href="view_users.php?s=' . ($start + $display) . '&np=' . $num_pages . '">Next</a>';
			}
			
			echo '</p><br />';
			
		} // End of links section.
		
		// Table header.
		echo '<table align="left" cellspacing="2" cellpadding="2">
		<tr><td align="left"><b>Name</b></td><td align="left"><b>Date Registered</b></td></tr>';
		
		// Fetch and print all the records.
		$bg = '#eeeeee'; // Set the background color.
		while ($row = mysql_fetch_array($result, MYSQL_NUM)) {
   			$bg = ($bg=='#eeeeee' ? '#ffffff' : '#eeeeee'); // Switch the background color.
			echo '<tr bgcolor="', $bg, '"><td align="left">', stripslashes($row[0]), '</td><td align="left">', $row[1], '</td></tr>
';
		}
	
		echo '</table>'; // Close the table.

		mysql_free_result ($result); // Free up the resources.	
	
	} else { // If there are no registered users.
		echo '<h3>There are currently no registered users.</h3>'; 
	}
	
	mysql_close(); // Close the database connection.
}

include_once ('../includes/admin_footer.html'); // Use the HTML footer file.
?>