<?php # Script 12.8 - logout.php
// This is the logout page for the site.

// Include the configuration file for error management and such.
require_once ('includes/config.inc'); 

// Set the page title and include the HTML header.
$page_title = 'Logout';
include_once ('includes/header.html');

// If no first_name variable exists, redirect the user.
if (!isset($_SESSION['first_name'])) {

	header ("Location:  http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/index.php");
	ob_end_clean(); // Delete the buffer.
	exit(); // Quit the script.
	
} else { // Logout the user.

	$_SESSION = array(); // Destroy the variables.
	session_destroy(); // Destroy the session itself.
	setcookie (session_name(), '', time()-300, '/', '', 0); // Destroy the cookie.

}

// Print a customized message.
echo "<h3>You are now logged out.</h3>";

include ('includes/footer.html'); // Include the HTML footer.
?>