<?php # Script 3.7 - handle_calculator.php

// Set the page title and include the HTML header.
$page_title = 'Calculator';
include ('./header.inc');

# ----------------------
// This function calculates a total based upon quantity, price, and tax and then prints the results.
function calculate_total ($quantity, $price, $taxrate) {

	$total = ($quantity * $price) * ($taxrate + 1);
	$total = number_format ($total, 2);
	echo "<p>You are purchasing <b>$quantity</b> widget(s) at a cost of <b>\$$price</b> each. With tax, the total comes to <b>\$$total</b>.</p>\n";
	
} // End of calculate_total() function.
# ----------------------

// Main conditional.
if (is_numeric($_POST['quantity'])) { // Is the quantity a number?

	calculate_total ($_POST['quantity'], $_POST['price'], $_POST['taxrate']);

} else { // Quantity is not a number.
	echo '<p><b>Please enter a valid quantity to purchase!</b></p>';
}
	
include ('./footer.inc'); // Include the HTML footer.
?>