<?php # Script 3.9 - handle_calculator.php

// Set the page title and include the HTML header.
$page_title = 'Calculator';
include ('./header.inc');

# ----------------------
// This function calculates a total based upon quantity, price, and tax and then returns the results.
function calculate_total ($quantity, $price = 19.95, $taxrate = .05) {

	$total = ($quantity * $price) * ($taxrate + 1);
	return number_format ($total, 2);
	
} // End of calculate_total() function.
# ----------------------

// Main conditional.
if (is_numeric($_POST['quantity'])) { // Is the quantity a number?
		
	$total = calculate_total ($_POST['quantity']);
	echo "<p>You are purchasing <b>{$_POST['quantity']}</b> widget(s) at a cost of <b>\${$_POST['price']}</b> each. With tax, the total comes to <b>\$$total</b>.</p>\n";

} else { // Quantity is not a number.
	echo '<p><b>Please enter a valid quantity to purchase!</b></p>';
}
	
include ('./footer.inc'); // Include the HTML footer.
?>