<?php # Script 11.5 - add_url.php
// This page allows users to add URLs to the database.

// Set the page title and include the HTML header.
$page_title = 'Add a URL';
include ('includes/header.html');

require_once ('../mysql_connect.php'); // Connect to the database.

if (isset($_POST['submit'])) { // Handle the form.

	// Function for escaping and trimming form data.
	function escape_data ($data) { 
		global $dbc;
		if (ini_get('magic_quotes_gpc')) {
			$data = stripslashes($data);
		}
		return mysql_real_escape_string (trim ($data), $dbc);
	} // End of escape_data() function.

	// Check for a URL.
	if (!empty($_POST['url'])) {
		$u = escape_data($_POST['url']);
	} else {
		$u = FALSE;
		echo '<p><font color="red">Please enter a URL!</font></p>';
	}
	
	// Check for a URL title.
	if (!empty($_POST['title'])) {
		$t = escape_data($_POST['title']);
	} else {
		$t = FALSE;
		echo '<p><font color="red">Please enter a URL name/title!</font></p>';
	}
	
	// Check for a description (not required).
	if (!empty($_POST['description'])) {
		$d = escape_data($_POST['description']);
	} else {
		$d = '';
	}
	
	// Check for a category.
	if (($_POST['type1'] > 0) OR ($_POST['type2'] > 0) OR ($_POST['type3']) > 0) {
		$type = TRUE;
	} else {
		$type = FALSE;
		echo '<p><font color="red">Please select at least one category!</font></p>';
	}
		
	if ($u && $t && $type) { // If everything's OK.

		// Add the URL to the url_titles table.
		$query = "INSERT INTO url_titles (url, title, description) VALUES ('$u', '$t', '$d')";		
		$result = @mysql_query ($query); // Run the query.
		$tid = @mysql_insert_id(); // Get the title ID.

		if ($tid > 0) { // If it ran OK.
		
			// Build the query.
			$query = 'INSERT INTO urls (title_id, type_id, approved, date_submitted) VALUES ';
			if ($_POST['type1'] > 0) {
				$query .= "($tid, {$_POST['type1']}, 'Y', NOW()), ";		
			}
			if ($_POST['type2'] > 0) {
				$query .= "($tid, {$_POST['type2']}, 'Y', NOW()), ";		
			}
			if ($_POST['type3'] > 0) {
				$query .= "($tid, {$_POST['type3']}, 'Y', NOW()), ";		
			}
			$query = substr ($query, 0, -2); // Chop off the last comma and space.

			// Run the query.
			$result = @mysql_query ($query);
			if ($result) {
				echo '<p><b>Thank you for your submission!</b></p>';
				$_POST = array();
			} else { // If it did not run OK.
				echo '<p><font color="red">Your submission could not be processed due to a system error. We apologize for any inconvenience.</font></p>'; 
			}
			
		} else { // If it did not run OK.
			echo '<p><font color="red">Your submission could not be processed due to a system error. We apologize for any inconvenience.</font></p>'; 
		}		

	} else { // If one of the data tests failed.
		echo '<p><font color="red">Please try again.</font></p>';		
	}

} // End of the main Submit conditional.

// --------- DISPLAY THE FORM ---------

// Create the pull-down menu information.
$query = "SELECT * FROM url_types ORDER BY type ASC";		
$result = @mysql_query ($query);
$pulldown = '<option>Select One</option>
';
while ($row = mysql_fetch_array ($result, MYSQL_ASSOC)) {
	$pulldown .= "<option value=\"{$row['type_id']}\">{$row['type']}</option>\n";
}
?>
	
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
<fieldset><legend>Fill out the form to submit a URL (you may choose up to 3 categories):</legend>

<p><b>URL:</b> <input type="text" name="url" size="60" maxlength="60" value="<?php if (isset($_POST['url'])) echo $_POST['url']; ?>" /><br /><small>Do not include the initial <i>http://</i></small></p>

<p><b>URL Name/Title:</b> <input type="text" name="title" size="60" maxlength="60" value="<?php if (isset($_POST['title'])) echo $_POST['title']; ?>" /></p>

<p><b>Description:</b> <textarea name="description" cols="40" rows="5"><?php if (isset($_POST['description'])) echo $_POST['description']; ?></textarea></p>

<p><b>Category 1:</b> <select name="type1">
<?php echo $pulldown; ?>
</select></p>

<p><b>Category 2:</b> <select name="type2">
<?php echo $pulldown; ?>
</select></p>

<p><b>Category 3:</b> <select name="type3">
<?php echo $pulldown; ?>
</select></p>

</fieldset>
	
<div align="center"><input type="submit" name="submit" value="Submit" /></div>

</form><!-- End of Form -->

<?php
mysql_close(); // Close the database connection.
include ('includes/footer.html'); // Include the HTML footer.
?>