<?php # Script 12.6 - register.php
// This is the registration page for the site.

// Include the configuration file for error management and such.
require_once ('includes/config.inc'); 

// Set the page title and include the HTML header.
$page_title = 'Register';
include ('includes/header.html');

if (isset($_POST['submit'])) { // Handle the form.

	require_once ('../mysql_connect.php'); // Connect to the database.
	
	// Check for a first name.
	if (eregi ("^[[:alpha:].' -]{2,15}$", stripslashes(trim($_POST['first_name'])))) {
		$fn = escape_data($_POST['first_name']);
	} else {
		$fn = FALSE;
		echo '<p><font color="red" size="+1">Please enter your first name!</font></p>';
	}
	
	// Check for a last name.
	if (eregi ("^[[:alpha:].' -]{2,30}$", stripslashes(trim($_POST['last_name'])))) {
		$ln = escape_data($_POST['last_name']);
	} else {
		$ln = FALSE;
		echo '<p><font color="red" size="+1">Please enter your last name!</font></p>';
	}
	
	// Check for an email address.
	if (eregi ("^[[:alnum:]][a-z0-9_.-]*@[a-z0-9.-]+\.[a-z]{2,4}$", stripslashes(trim($_POST['email'])))) {
		$e = escape_data($_POST['email']);
	} else {
		$e = FALSE;
		echo '<p><font color="red" size="+1">Please enter a valid email address!</font></p>';
	}

	// Check for a username.
	if (eregi ("^[[:alnum:]_]{4,20}$", stripslashes(trim($_POST['username'])))) {
		$u = escape_data($_POST['username']);
	} else {
		$u = FALSE;
		echo '<p><font color="red" size="+1">Please enter a valid username!</font></p>';
	}
	
	// Check for a password and match against the confirmed password.
	if (eregi ("^[[:alnum:]]{4,20}$", stripslashes(trim($_POST['password1'])))) {
		if ($_POST['password1'] == $_POST['password2']) {
			$p = escape_data($_POST['password1']);
		} else {
			$p = FALSE;
			echo '<p><font color="red" size="+1">Your password did not match the confirmed password!</font></p>';
		}
	} else {
		$p = FALSE;
		echo '<p><font color="red" size="+1">Please enter a valid password!</font></p>';
	}
	
	if ($fn && $ln && $e && $u && $p) { // If everything's OK.

		// Make sure the username is available.
		$query = "SELECT user_id FROM users WHERE username='$u'";		
		$result = @mysql_query ($query);
		
		if (mysql_num_rows($result) == 0) { // Available.
		
			// Add the user.
			$query = "INSERT INTO users (username, first_name, last_name, email, password, registration_date) VALUES ('$u', '$fn', '$ln', '$e', PASSWORD('$p'), NOW() )";		
			$result = @mysql_query ($query); // Run the query.

			if ($result) { // If it ran OK.
			
				// Send an email, if desired.
				echo '<p><b>Thank you for registering!</b></p>';
				include ('includes/footer.html'); // Include the HTML footer.
				exit();				
				
			} else { // If it did not run OK.
				// Send a message to the error log, if desired.
				echo '<p><font color="red" size="+1">You could not be registered due to a system error. We apologize for any inconvenience.</font></p>'; 
			}		
			
		} else { // The username is not available.
			echo '<p><font color="red" size="+1">That username is already taken.</font></p>'; 
		}
		
		mysql_close(); // Close the database connection.

	} else { // If one of the data tests failed.
		echo '<p><font color="red" size="+1">Please try again.</font></p>';		
	}

} // End of the main Submit conditional.
?>
	
	<h1>Register</h1>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
	<fieldset>
	
	<p><b>First Name:</b> <input type="text" name="first_name" size="15" maxlength="15" value="<?php if (isset($_POST['first_name'])) echo $_POST['first_name']; ?>" /></p>
	
	<p><b>Last Name:</b> <input type="text" name="last_name" size="30" maxlength="30" value="<?php if (isset($_POST['last_name'])) echo $_POST['last_name']; ?>" /></p>
	
	<p><b>Email Address:</b> <input type="text" name="email" size="40" maxlength="40" value="<?php if (isset($_POST['email'])) echo $_POST['email']; ?>" /> </p>
	
	<p><b>User Name:</b> <input type="text" name="username" size="10" maxlength="20" value="<?php if (isset($_POST['username'])) echo $_POST['username']; ?>" /> <small>Use only letters, numbers, and the underscore. Must be between 4 and 20 characters long.</small></p>
	
	<p><b>Password:</b> <input type="password" name="password1" size="20" maxlength="20" /> <small>Use only letters and numbers. Must be between 4 and 20 characters long.</small></p>
	
	<p><b>Confirm Password:</b> <input type="password" name="password2" size="20" maxlength="20" /></p>
	</fieldset>
	
	<div align="center"><input type="submit" name="submit" value="Register" /></div>
	
	</form><!-- End of Form -->

<?php // Include the HTML footer.
include ('includes/footer.html');
?>