# SQL Commands from "PHP and MySQL for Dynamic Web Sites: Visual QuickPro Guide"
# Written by Larry Ullman, Published May 2003

# This file contains the SQL statements used in the book, listed by chapter.
# The SQL commands here are from the steps where they are entered into the MySQL monitor.
# SQL commands from the tips and from the PHP scripts are not included.
# You SHOULD NOT attempt to run this file in MySQL as is. Cut and paste the specific commands as needed.
# Some later table creation commands are preceeded by a DROP TABLE command. This will delete an existing table and ALL DATA.

# ---------
# Chapter 4
# ---------
CREATE DATABASE sitename;

USE sitename;

CREATE TABLE users (
user_id MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,
first_name VARCHAR(15) NOT NULL,
last_name VARCHAR(30) NOT NULL,
email VARCHAR(40),
password CHAR(16) NOT NULL,
registration_date DATETIME NOT NULL,
PRIMARY KEY (user_id)
);

INSERT INTO users (first_name, last_name, email, password, registration_date) VALUES ('Larry', 'Ullman', 'phpmysql@DMCInsights.com', PASSWORD('password'), NOW());

INSERT INTO users VALUES (NULL, 'Larry', 'Ullman', 'phpmysql@DMCInsights.com', PASSWORD('password'), NOW());

INSERT INTO users (first_name, last_name, email, password, registration_date) VALUES
('John', 'Lennon', 'john@beatles.com', PASSWORD('Happin3ss'), NOW()),
('Paul', 'McCartney', 'paul@beatles.com', PASSWORD('letITbe'), NOW()),
('George', 'Harrison', 'george@beatles.com ', PASSWORD('something'), NOW()),
('Ringo', 'Starr', 'ringo@beatles.com', PASSWORD('thisboy'), NOW());

SELECT * FROM users;

SELECT first_name, last_name FROM users;
  
SELECT * FROM users WHERE (registration_date > '2003-01-27 00:00:00') AND (registration_date < '2003-01-28 00:00:00');

SELECT first_name FROM users WHERE last_name = 'Simpson';

SELECT * FROM users WHERE email IS NULL;

SELECT * FROM users WHERE password= PASSWORD('password');

SELECT * FROM users WHERE last_name LIKE 'Bank%';

SELECT first_name, last_name FROM users WHERE email NOT LIKE '%@authors.com';

SELECT first_name, last_name FROM users ORDER BY last_name;

SELECT first_name, last_name FROM users ORDER BY last_name ASC, first_name ASC;

SELECT * FROM users ORDER BY registration_date DESC;

SELECT * FROM users ORDER BY registration_date DESC LIMIT 5;
  
SELECT * FROM users ORDER BY registration_date ASC LIMIT 1, 1;

SELECT user_id FROM users WHERE first_name = 'Michael' AND last_name='Chabon';

UPDATE users SET email='mike@authors.com' WHERE user_id = 17;

SELECT * FROM users WHERE user_id=17;

SELECT user_id FROM users WHERE first_name = 'Aimee' AND last_name='Mann';

SELECT * FROM users WHERE user_id = 22;

DELETE FROM users WHERE user_id = 22;

SELECT user_id, first_name, last_name FROM users ORDER BY user_id ASC;  
  
# ---------
# Chapter 5
# ---------

CREATE DATABASE content;

USE content;

CREATE TABLE urls (
url_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
title_id SMALLINT(4) UNSIGNED NOT NULL,
type_id TINYINT(3) UNSIGNED NOT NULL,
approved CHAR(1),
date_submitted TIMESTAMP,
PRIMARY KEY (url_id)
);

CREATE TABLE url_types (
type_id TINYINT(3) UNSIGNED NOT NULL AUTO_INCREMENT,
type VARCHAR(20) NOT NULL,
PRIMARY KEY (type_id)
);

CREATE TABLE url_titles (
title_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
url VARCHAR(60) NOT NULL,
title VARCHAR(60) NOT NULL,
description TINYTEXT NOT NULL,
PRIMARY KEY (title_id)
);

SHOW TABLES;

SHOW COLUMNS FROM urls;

SHOW COLUMNS FROM url_types;

SHOW COLUMNS FROM url_titles;

INSERT INTO url_types (type) VALUES ('General PHP'), ('Web Development'), ('Code Libraries'), ('Programming'), ('General MySQL'), ('General Database');

INSERT INTO url_titles (url, title, description) VALUES 
('www.php.net', 'PHP: Hypertext Preprocessor', 'The home page of PHP...'),
('www.mysql.com', 'MySQL: The World\'s Most Popular Open Source Database', 'The home page of MySQL...'), 
('www.w3.org', 'World Wide Web Consortium', 'The home page of the W3C...'), 
('www.Zend.com', 'Zend', 'The home page of Zend...');

SELECT * FROM url_types;

SELECT title_id, title FROM url_titles;

INSERT INTO urls (title_id, type_id, approved, date_submitted) VALUES
(1,1,'Y', NOW()),
(1,4,'Y', NOW()),
(1,2,'Y', NOW()),
(2,5,'Y', NOW()),
(2,2,'Y', NOW()),
(3,2,'Y', NOW()),
(4,1,'Y', NOW()),
(4,3,'Y', NOW());

SELECT type FROM urls AS u, url_types AS t WHERE u.type_id = t.type_id;

SELECT type, url FROM urls AS u, url_types AS t, url_titles AS ut WHERE u.type_id = t.type_id AND u.title_id = ut.title_id ORDER BY t.type_id;

SELECT type, url FROM url_types LEFT JOIN urls USING (type_id) LEFT JOIN url_titles USING (title_id) ORDER BY url_types.type_id;

SELECT TRIM(url) FROM url_titles;

SELECT CONCAT(url, '', title) AS heading FROM url_titles;

SELECT LENGTH(url) AS L, url FROM url_titles ORDER BY L DESC LIMIT 1;

SELECT CONCAT('$', FORMAT(5639.6, 2)) AS cost;

SELECT type, url FROM urls AS u, url_types AS t, url_titles AS ut WHERE u.type_id = t.type_id AND u.title_id = ut.title_id ORDER BY RAND() LIMIT 1;

SELECT type, url FROM urls AS u, url_types AS t, url_titles AS ut WHERE u.type_id = t.type_id AND u.title_id = ut.title_id AND MONTH(u.date_submitted)=2 ORDER BY t.type_id;

SELECT CURDATE(), CURTIME();

SELECT DATE_FORMAT(NOW(),'%M %e, %Y - %l:%i');

SELECT TIME_FORMAT(CURTIME(),'%T');

SELECT DATE_FORMAT(date_submitted, '%a %b %e %Y') AS Date, type AS Type, url AS URL FROM url_types t, urls u, url_titles ut WHERE t.type_id=u.type_id AND u.title_id=ut.title_id ORDER BY u.date_submitted DESC;
  
SELECT title FROM urls u, url_titles t WHERE u.title_id=t.title_id GROUP BY u.title_id;
  
SELECT url, COUNT(*) AS Number FROM urls u, url_titles t WHERE u.title_id=t.title_id GROUP BY u.title_id;

SELECT url, COUNT(*) AS Number FROM urls u, url_titles t WHERE u.title_id=t.title_id GROUP BY u.title_id ORDER BY Number DESC;
  
ALTER TABLE url_types ADD UNIQUE (type);

ALTER TABLE url_titles ADD UNIQUE (url);

ALTER TABLE urls ADD INDEX (title_id), ADD INDEX (type_id), ADD INDEX (date_submitted);
  
DESCRIBE url_types;

DESCRIBE url_titles;

DESCRIBE urls;

# ---------
# Chapter 6
# ---------
USE sitename;

DESCRIBE users;

ALTER TABLE users ADD COLUMN username VARCHAR(20) AFTER user_id;

ALTER TABLE users ADD UNIQUE (username), ADD INDEX (first_name), ADD INDEX (last_name), ADD INDEX (password);

DESCRIBE users;

# ---------
# Chapter 8
# ---------
CREATE DATABASE ecommerce;

USE ecommerce;

CREATE TABLE customers (
customer_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
username VARCHAR(16) NOT NULL,
password CHAR(16) NOT NULL,
card_number TINYBLOB,
PRIMARY KEY (customer_id)
);

INSERT INTO customers (username, password, card_number) VALUES ('trout', PASSWORD('MYpassword'), ENCODE(1234567890123456, 'eLL10tT'));
  
SELECT username, password, DECODE(card_number, 'eLL10tT') AS cc FROM customers;

# ---------
# Chapter 9
# ---------
USE mysql;
UPDATE user SET password=PASSWORD ('tR0utSt3r') WHERE user='root';
  
USE sitename;

OPTIMIZE TABLE users;

USE ecommerce;

EXPLAIN SELECT * FROM customers WHERE username = 'trout' AND password = PASSWORD('MYpassword');

ALTER TABLE customers ADD INDEX (username), ADD INDEX (password);

ANALYZE TABLE customers;

EXPLAIN SELECT * FROM customers WHERE username = 'trout' AND password = PASSWORD('MYpassword');

# ----------
# Chapter 11
# ----------
USE content;

CREATE TABLE uploads (
upload_id int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
file_name VARCHAR(30) NOT NULL,
file_size INT(6) UNSIGNED NOT NULL,
file_type VARCHAR(30) NOT NULL,
description VARCHAR(100) DEFAULT NULL,
upload_date DATETIME NOT NULL,
PRIMARY KEY (upload_id),
KEY file_name (file_name)
);

DROP TABLE IF EXISTS url_titles;
CREATE TABLE url_titles (
title_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
url VARCHAR(60) NOT NULL,
title VARCHAR(60) NOT NULL,
description TINYTEXT NOT NULL,
PRIMARY KEY (title_id),
UNIQUE KEY url (url)
);

DROP TABLE IF EXISTS url_types;
CREATE TABLE url_types (
type_id TINYINT(3) UNSIGNED NOT NULL AUTO_INCREMENT,
type VARCHAR(20) NOT NULL,
PRIMARY KEY (type_id),
UNIQUE KEY type (type)
);

DROP TABLE IF EXISTS urls;
CREATE TABLE urls (
url_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
title_id SMALLINT(4) UNSIGNED NOT NULL,
type_id tinyint(3) UNSIGNED NOT NULL,
approved CHAR(1) DEFAULT 'N',
date_submitted TIMESTAMP(14) NOT NULL,
PRIMARY KEY (url_id),
KEY title_id (title_id),
KEY type_id (type_id),
KEY date_submitted (date_submitted)
);

SHOW TABLES;

DESCRIBE url_types;
DESCRIBE urls;
DESCRIBE url_titles;

# ----------
# Chapter 12
# ----------
USE sitename;

DROP TABLE IF EXISTS users;
CREATE TABLE users (
user_id mediumint(8) unsigned NOT NULL auto_increment,
username varchar(20) NOT NULL,
first_name varchar(15) NOT NULL,
last_name varchar(30) NOT NULL,
email varchar(40) NULL,
password varchar(16) NOT NULL,
registration_date datetime NOT NULL,
PRIMARY KEY (user_id),
UNIQUE KEY username (username),
KEY first_name (first_name),
KEY last_name (last_name),
KEY password (password)
) TYPE=MyISAM;

# ----------
# Chapter 13
# ----------
USE ecommerce;

CREATE TABLE artists (
artist_id INT(3) UNSIGNED NOT NULL
AUTO_INCREMENT,
first_name VARCHAR(20),
middle_name VARCHAR(20),
last_name VARCHAR(30) NOT NULL,
PRIMARY KEY (artist_id),
KEY last_name (last_name),
KEY full_name (last_name, first_name)
);

CREATE TABLE prints (
print_id INT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
artist_id INT(3) UNSIGNED NOT NULL,
print_name VARCHAR(60) NOT NULL,
price decimal(6,2) NOT NULL,
size VARCHAR(60) default NULL,
description VARCHAR(255) default NULL,
image_name VARCHAR(30) default NULL,
PRIMARY KEY (print_id),
KEY artist_id (artist_id),
KEY print_name (print_name)
);

DROP TABLE IF EXISTS customers;
CREATE TABLE customers (
customer_id INT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
username VARCHAR(16) NOT NULL,
password VARCHAR(16) NOT NULL,
card_number TINYBLOB,
PRIMARY KEY (customer_id),
KEY username (username),
KEY password (password),
KEY user_pass (username, password)
);

CREATE TABLE orders (
order_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
customer_id INT(5) UNSIGNED NOT NULL,
total decimal(10,2) UNSIGNED NOT NULL,
order_date datetime NOT NULL,
approved char(1) NOT NULL default 'N',
cart VARCHAR(75) NOT NULL,
PRIMARY KEY (order_id),
KEY customer_id (customer_id),
KEY order_date (order_date)
);