<?php # Script 15.3 - pdf_hello.php

/* 
 *	This page generates a one-page PDF
 *	that has a simple message.
 */

// Set the constants for dimensions:
// 72 points per inch
define ('PAGE_WIDTH', 612); // 8.5 inches
define ('PAGE_HEIGHT', 792); // 11 inches
define ('INCH', 72);
define ('FONT_SIZE', (INCH/2));

// Use a try...catch block.
try {

	// Make the PDF object:
    $pdf = new PDFlib();
    
    // Begin a new document:
	$pdf->begin_document(NULL, NULL);
	
	// Set the PDF metadata:
	$pdf->set_info ('Author', 'Larry E. Ullman');
	$pdf->set_info ('Title', 'Hello, world!');

	// Create the first page:
    $pdf->begin_page_ext(PAGE_WIDTH, PAGE_HEIGHT, NULL);

	// Load the font:
    $font = $pdf->load_font('Times-Roman', 'host', NULL);

	// Set the font's size:
    $pdf->setfont($font, FONT_SIZE);
    
    // Say hello:
    $pdf->show_xy('Hello, world!', INCH, (PAGE_HEIGHT - INCH - FONT_SIZE));
    
    // Say something else:
    $pdf->continue_text('Hello, universe!');
    
	// End the page:
    $pdf->end_page_ext(NULL);
    
	// End the document:
    $pdf->end_document(NULL);

	// Get the buffer:
    $buffer = $pdf->get_buffer();
    
    // Send the headers:
    header('Content-type: application/pdf');
    header('Content-Length: ' . strlen($buffer));
    header('Content-Disposition: inline; filename="hello.pdf"');
    
    // Send the PDF:
    echo $buffer;
    
    // Delete the PDF in memory:
    $pdf->delete();

} catch (PDFlibException $e) { // Catch PDFlib exceptions.

    die("A PDFlib exception occurred:\n" .  $e->get_errmsg());

} catch (Exception $e) { // Catch general exceptions.

    die($e->getMessage());

}

?>
