<?php # Script 15.4 - pdf_invoice.php

/* 
 *	This page generates a one-page PDF
 *	that serves as an invoice.
 */

// Set the constants for dimensions:
// 72 points per inch
define ('PAGE_WIDTH', 612); // 8.5 inches
define ('PAGE_HEIGHT', 792); // 11 inches
define ('INCH', 72);
define ('FONT_SIZE', (INCH/4)); // 0.25 inch type

// Set the variables:
$client = 'Acme Industries';
$amount = 890.45;

// Use a try...catch block.
try {

	// Do the basic stuff:
    $pdf = new PDFlib();
	$pdf->begin_document(NULL, NULL);
	$pdf->set_info ('Author', 'Larry E. Ullman');
	$pdf->set_info ('Title', 'Invoice');
	$pdf->begin_page_ext(PAGE_WIDTH, PAGE_HEIGHT, NULL);

	// Create a centered title...
	
	// Set the font:
	$helvetica_obl = $pdf->load_font ('Helvetica-Oblique', 'host', NULL);
	$pdf->setfont($helvetica_obl, (FONT_SIZE * 2));
	
	// Change the color and add some rendering:
	$pdf->setcolor('both', 'rgb', .2, .4, .6, 0);
	$pdf->set_value ('textrendering', 1);
	
	// Calculate the string width and center the text on the page:
	$stringwidth = $pdf->stringwidth('Invoice For Services Completed', $helvetica_obl, (FONT_SIZE * 2));
    $pdf->show_xy('Invoice For Services Completed', ( (PAGE_WIDTH/2) - ($stringwidth/2) ), (PAGE_HEIGHT - INCH - (FONT_SIZE * 2)));

	// Set the default font & formatting from here on out:
	$times = $pdf->load_font ('Times-Roman', 'host', NULL);
	$pdf->setfont ($times, FONT_SIZE);
	$pdf->set_value ('textrendering', 0);
	$pdf->setcolor('both', 'rgb', 0, 0, 0, 0);
	
	// Adjust the leading:
	$pdf->set_value ('leading', (FONT_SIZE * 2) );
	
	// Print the remaining lines...
	
	// Each caption is underlined:
	$pdf->set_parameter ('underline', 'true');
    $pdf->show_xy('Invoice Date:', INCH, (PAGE_HEIGHT - (INCH * 3)));
    
    // Each value is NOT underlined:
	$pdf->set_parameter ('underline', 'false');
	$pdf->show (' ' . date('F j, Y')); 

	$pdf->set_parameter ('underline', 'true');
	$pdf->continue_text ('Client:'); 
	$pdf->set_parameter ('underline', 'false');
	$pdf->show (" $client"); 

	$pdf->set_parameter ('underline', 'true');
	$pdf->continue_text ('Amount Due:'); 
	$pdf->set_parameter ('underline', 'false');
	$pdf->show (" \$$amount"); 
	    
	// Wrap up:
    $pdf->end_page_ext(NULL);
    $pdf->end_document(NULL);

	// Send it out:
    $buffer = $pdf->get_buffer();
    header('Content-type: application/pdf');
    header('Content-Length: ' . strlen($buffer));
    header('Content-Disposition: inline; filename="invoice.pdf"');
    echo $buffer;
    
    // Delete the PDF in memory:
    $pdf->delete();

} catch (PDFlibException $e) { // Catch PDFlib exceptions.

    die("A PDFlib exception occurred:\n" .  $e->get_errmsg());

} catch (Exception $e) { // Catch general exceptions.

    die($e->getMessage());

}

?>
