<?php # Script 15.5 - pdf_invoice2.php

/* 
 *	This page generates a one-page PDF
 *	that serves as an invoice.
 *	The invoice now includes a description box.
 */

// Set the constants for dimensions:
// 72 points per inch
define ('PAGE_WIDTH', 612); // 8.5 inches
define ('PAGE_HEIGHT', 792); // 11 inches
define ('INCH', 72);
define ('FONT_SIZE', (INCH/4)); // 0.25 inch type

// Set the variables:
$client = 'Acme Industries';
$amount = 890.45;

// Add the invoice description:
$description = 'This is the invoice description. ';
for ($i = 0; $i < 3; $i++) $description .= $description;

// Use a try...catch block.
try {

	// Do the basic stuff:
    $pdf = new PDFlib();
	$pdf->begin_document(NULL, NULL);
	$pdf->set_info ('Author', 'Larry E. Ullman');
	$pdf->set_info ('Title', 'Invoice');
    $pdf->begin_page_ext(PAGE_WIDTH, PAGE_HEIGHT, NULL);

	// Create a centered title:
	$helvetica_obl = $pdf->load_font ('Helvetica-Oblique', 'host', NULL);
	$pdf->setfont($helvetica_obl, (FONT_SIZE * 2));
	$pdf->setcolor('both', 'rgb', .2, .4, .6, 0);
	$pdf->set_value ('textrendering', 1);
	$stringwidth = $pdf->stringwidth('Invoice For Services Completed', $helvetica_obl, (FONT_SIZE * 2));
    $pdf->show_xy('Invoice For Services Completed', ( (PAGE_WIDTH/2) - ($stringwidth/2) ), (PAGE_HEIGHT - INCH - (FONT_SIZE * 2)));
    
	// Set the default font from here on out:
	$times = $pdf->load_font ('Times-Roman', 'host', NULL);
	$pdf->setfont ($times, FONT_SIZE);
	$pdf->set_value ('textrendering', 0);
	$pdf->setcolor('both', 'rgb', 0, 0, 0, 0);
	
	// Adjust the leading:
	$pdf->set_value ('leading', (FONT_SIZE * 2) );
	
	// Print the remaining lines:
	$pdf->set_parameter ('underline', 'true');
    $pdf->show_xy('Invoice Date:', INCH, (PAGE_HEIGHT - (INCH * 3)));
	$pdf->set_parameter ('underline', 'false');
	$pdf->show (' ' . date('F j, Y')); 
	
	// Add this line to the used height:
	$used_height = (INCH * 3) + FONT_SIZE;

	$pdf->set_parameter ('underline', 'true');
	$pdf->continue_text ('Client:'); 
	$pdf->set_parameter ('underline', 'false');
	$pdf->show (" $client"); 
	$used_height += (FONT_SIZE * 2);

	$pdf->set_parameter ('underline', 'true');
	$pdf->continue_text ('Amount Due:'); 
	$pdf->set_parameter ('underline', 'false');
	$pdf->show (" \$$amount"); 
	$used_height += (FONT_SIZE * 2);

	// Show the description:
	$pdf->set_parameter ('underline', 'true');
	$pdf->continue_text ('Description of Work:'); 
	$pdf->set_parameter ('underline', 'false');
	$used_height += (FONT_SIZE * 2);

	// Adjust the leading:
	$pdf->set_value ('leading', (FONT_SIZE * 1.25) );

	// Determine the "description of work" box size:			
	$box_height = FONT_SIZE; // Start as one line tall.
	while (($pdf->show_boxed ($description, INCH, (PAGE_HEIGHT - $used_height - $box_height), (PAGE_WIDTH - (INCH * 2)), $box_height, 'left', 'blind')) > 0 ) {
		$box_height += FONT_SIZE; // Add another line.
	} 
	
	$remaining_space = PAGE_HEIGHT - ($used_height + INCH);
	
	$font_size = FONT_SIZE;
	while ( $box_height > $remaining_space ) {
		$font_size = $font_size - 2;
		$pdf->setfont($times, $font_size);
		
		$box_height = $font_size;
		while (($pdf->show_boxed ($description, INCH, (PAGE_HEIGHT - $used_height - $box_height), (PAGE_WIDTH - (INCH * 2)), $box_height, 'left', 'blind')) > 0 ) {
			$box_height += $font_size;
		} 
	} 

	// Actually print the description:
	$pdf->show_boxed ($description, INCH, (PAGE_HEIGHT - $used_height - $box_height), (PAGE_WIDTH - (INCH * 2)), $box_height, 'left', NULL); 
    
	// Wrap up:
    $pdf->end_page_ext(NULL);
    $pdf->end_document(NULL);

	// Send it out:
    $buffer = $pdf->get_buffer();
    header('Content-type: application/pdf');
    header('Content-Length: ' . strlen($buffer));
    header('Content-Disposition: inline; filename="invoice.pdf"');
    echo $buffer;
    
    // Delete the PDF in memory:
    $pdf->delete();

} catch (PDFlibException $e) { // Catch PDFlib exceptions.

    die("A PDFlib exception occurred:\n" .  $e->get_errmsg());

} catch (Exception $e) { // Catch general exceptions.

    die($e->getMessage());

}

?>
