<?php # Script 15.7 - pdf_smiley.php

/* 
 *	This page generates a one-page PDF
 *	that has a smiley face on it.
 */

// Set the constants for dimensions:
// 72 points per inch
define ('PAGE_WIDTH', 612); // 8.5 inches
define ('PAGE_HEIGHT', 792); // 11 inches
define ('INCH', 72);

// Use a try...catch block.
try {

	// Make the PDF object:
    $pdf = new PDFlib();
    
    // Begin a new document:
	$pdf->begin_document(NULL, NULL);
	
	// Set the PDF metadata:
	$pdf->set_info ('Author', 'Larry E. Ullman');
	$pdf->set_info ('Title', 'Smiley Face');

	// Create the first page:
    $pdf->begin_page_ext(PAGE_WIDTH, PAGE_HEIGHT, NULL);

	// Set the line in gray, slightly thicker width:
	$pdf->setlinewidth (4);
	$pdf->setcolor ('both', 'rgb', 0.8, 0.8, 0.8, 0);
	
	// Create the big circle (a face):
	$pdf->circle ((PAGE_WIDTH/2), (PAGE_HEIGHT/2), ( (PAGE_WIDTH - INCH - INCH)/2) );
	$pdf->stroke();
	
	// Create the eyes:
	$pdf->circle ((round (PAGE_WIDTH/3) * 1), (PAGE_HEIGHT - (PAGE_HEIGHT/3)), 18);
	$pdf->stroke();
	$pdf->circle ( (round (PAGE_WIDTH/3) * 2), (PAGE_HEIGHT - (PAGE_HEIGHT/3)), 18);
	$pdf->stroke();
	
	// Create the mouth:
	$pdf->arc ((PAGE_WIDTH/2), (PAGE_HEIGHT/2), 144, 210, 330);
	$pdf->stroke();

	// Make a nose...
	
	// Change the line color, width, capping, and dash:
	$pdf->setcolor ('both', 'rgb', 1.0, 0.6, 0.2, 0);
	$pdf->setlinewidth (12);
	$pdf->setlinecap (1);
	$pdf->setdash (20, 15);
	
	// Add an angled nose:
	$pdf->moveto ((PAGE_WIDTH/2) + 10, (PAGE_HEIGHT/2) + 75);
	$pdf->lineto ((PAGE_WIDTH/2) - 30, (PAGE_HEIGHT/2) - 20);
	$pdf->lineto ((PAGE_WIDTH/2) + 10, (PAGE_HEIGHT/2) - 10);
	$pdf->stroke();

	// Place a frame around the page:
	$pdf->setcolor ('both', 'rgb', 0, 0, 0, 0);
	$pdf->setlinewidth (6);
	$pdf->setdash (0, 0);
	$pdf->setlinejoin (1);
	$pdf->rect ((INCH/2), (INCH/2), (PAGE_WIDTH - INCH), (PAGE_HEIGHT - INCH));
	$pdf->stroke();

	// End the page:
    $pdf->end_page_ext(NULL);
    
	// End the document:
    $pdf->end_document(NULL);

	// Get the buffer:
    $buffer = $pdf->get_buffer();
    
    // Send the headers:
    header('Content-type: application/pdf');
    header('Content-Length: ' . strlen($buffer));
    header('Content-Disposition: inline; filename="smiley.pdf"');
    
    // Send the PDF:
    echo $buffer;
    
    // Delete the PDF in memory:
    $pdf->delete();

} catch (PDFlibException $e) { // Catch PDFlib exceptions.

    die("A PDFlib exception occurred:\n" .  $e->get_errmsg());

} catch (Exception $e) { // Catch general exceptions.

    die($e->getMessage());

}

?>
