<?php # Script 15.2 - pdf_test.php

/* 
 *	This page generates a blank, one-page PDF.
 */

// Use a try...catch block.
try {

	// Make the PDF object:
    $pdf = new PDFlib();
    
    // Begin a new document:
	$pdf->begin_document(NULL, NULL);
	
	// Set the PDF metadata:
	$pdf->set_info ('Author', 'Larry E. Ullman');
	$pdf->set_info ('Title', 'My Blank PDF');

	// Create the first page:
    $pdf->begin_page_ext(612, 792, NULL);

	// End the page:
    $pdf->end_page_ext(NULL);
    
	// End the document:
    $pdf->end_document(NULL);

	// Get the buffer:
    $buffer = $pdf->get_buffer();
    
    // Send the headers:
    header('Content-type: application/pdf');
    header('Content-Length: ' . strlen($buffer));
    header('Content-Disposition: inline; filename="blank.pdf"');
    
    // Send the PDF:
    echo $buffer;
    
    // Delete the PDF in memory:
    $pdf->delete();

} catch (PDFlibException $e) { // Catch PDFlib exceptions.

    die("A PDFlib exception occurred:\n" . $e->get_errmsg());

} catch (Exception $e) { // Catch general exceptions.

    die($e->getMessage());

}

?>
