<?php # Script 14.2 - allocate_color.php

/* 	This function assigns the RGB values 
 * 	that correspond to certain color names.
 *	The function takes two arguments:
 *	- the image resource
 *	- the name of the color to use
 *	The function returns the allocated color.
 */ 

function allocate_color ($image = NULL, $color = 'white') {

	// Make sure an image was received:
	if (!$image) return FALSE;
	
	// Switch for the various colors:
	switch ($color) {
	
		case 'black':
			$red = 0;
			$green = 0;
			$blue = 0;
			break;	
		
		case 'blue':
			$red = 51;
			$green = 51;
			$blue = 255;
			break;	
			
		case 'green':
			$red = 51;
			$green = 255;
			$blue = 51;
			break;	
			
		case 'gray':
			$red = 153;
			$green = 153;
			$blue = 153;
			break;	
			
		case 'red':
			$red = 255;
			$green = 51;
			$blue = 51;
			break;	
			
		case 'purple':
			$red = 255;
			$green = 51;
			$blue = 255;
			break;	
			
		case 'orange':
			$red = 255;
			$green = 153;
			$blue = 51;
			break;	
			
		case 'yellow':
			$red = 255;
			$green = 255;
			$blue = 51;
			break;	
			
		case 'white':
		default: // Also white
			$red = 255;
			$green = 255;
			$blue = 255;
			break;	
			
	} // End of switch.
	
	// Return the allocated color:
	return imagecolorallocate ($image, $red, $green, $blue);
	
} // End of function definition.

?>
