<?php # Script 14.8 - generate_graph.php

/*
 *	This page creates a graph 
 *	based upon an array of data.
 *	The graph is then saved to the server.
 */
 
// Include the allocate_color() function:
require_once('allocate_color.php');

// Define the image information:
$font_file = 'arial.ttf'; // Full path to actual font file on server.
$font_size = 10; // Number in pixels
$image_width = 460; // = 400-pixel scale + (10-pixel spacer * 2) + 40 (for labels).
$image_height = 460; // = 400-pixel scale + (10-pixel spacer * 2) + 40 (for labels).
$file_name = 'graph.png'; // Full path.

// Array of data to plot:
$data = array (
'Brian' => array ('color' => 'blue', 1 => 65),
'Juan' => array ('color' => 'red', 1 => 78),
'Michael' => array ('color' => 'green', 1 => 85),
'Larry' => array ('color' => 'orange', 1 => 92)
);
$week = 1; // First of 10 weeks of results.

// Create the image:
$image = imagecreatetruecolor ($image_width, $image_height);

// Set the main colors:
$gray = allocate_color ($image, 'gray');
$black = allocate_color ($image, 'black');
$white = allocate_color ($image, 'white');

// Begin the base image:
imagefill ($image, 0, 0, $gray); // Not necessary but good form.
imagerectangle ($image, 0, 0, ($image_width-2), ($image_height-2), $black); // Border for the image.
imagefilledrectangle ($image, 50, 10, 450, 410, $white); // Graph background.
imagerectangle ($image, 50, 10, 450, 410, $black); // Border for the graph.

// Make the graph lines:
imagesetstyle ($image, array($black, $black, $black, $black, $black, $white, $white, $white, $white, $white, $white));
imageline ($image, 50, 90, 450, 90, IMG_COLOR_STYLED); // 20%
imageline ($image, 50, 170, 450, 170, IMG_COLOR_STYLED); // 40%
imageline ($image, 50, 250, 450, 250, IMG_COLOR_STYLED); // 60%
imageline ($image, 50, 330, 450, 330, IMG_COLOR_STYLED); // 80%

// Number the y axis:
imagettftext ($image, $font_size, 0, 40, 415, $black, $font_file, '0');
imagettftext ($image, $font_size, 0, 35, 335, $black, $font_file, '20');
imagettftext ($image, $font_size, 0, 35, 255, $black, $font_file, '40');
imagettftext ($image, $font_size, 0, 35, 175, $black, $font_file, '60');
imagettftext ($image, $font_size, 0, 35, 95, $black, $font_file, '80');
imagettftext ($image, $font_size, 0, 25, 15, $black, $font_file, '100');

// Number the x axis:
for ($i = 1; $i <= 10; $i++) {

	$x = ($i * 40) + 40; // Each week is 40 pixels + 40 pixel offset.
	imagettftext ($image, $font_size, 0, $x, 425, $black, $font_file, $i);
	
}

// Add the labels:
imagettftext ($image, ($font_size * 2), 90, 25, 280, $black, $font_file, 'Percentage');
imagettftext ($image, ($font_size * 2), 0, 180, 450, $black, $font_file, 'Week');

// Plot each person's results...

// x value based upon week number:
$x = ($week * 40) + 40;

foreach ($data as $person => $results) {

	// y value based upon percentage 
	// for that person for that week.
	// Subtract percentage from 100, multiple times 4 (for scale), add 10 for padding.
	$y = ((100 - $results[$week]) * 4) + 10;

	// Make the circle.
	imagefilledellipse ($image, $x, $y, 15, 15, allocate_color($image, $results['color']));

}

// Save the image on the server:
imagepng ($image, $file_name);

// Destroy the image:
imagedestroy ($image);

// Show the image in the browser:
header ('Content-type: image/png');
readfile($file_name);
?>
