<?php # Script 14.9 - generate_graph2.php

/*
 *	This page creates a graph 
 *	based upon an array of data.
 *	The graph is then saved to the server.
 */
 
// Include the allocate_color() function:
require_once('allocate_color.php');

// Define the image information:
$file_name = 'graph.png'; // Full path.

// Array of data to plot:
$data = array (
'Brian' => array ('color' => 'blue', 1 => 65, 2 => 65),
'Juan' => array ('color' => 'red', 1 => 78, 2 => 90),
'Michael' => array ('color' => 'green', 1 => 85, 2 => 80),
'Larry' => array ('color' => 'orange', 1 => 92, 2 => 85)
);
$week = 2; // Second of 10 weeks of results.

// Create the image:
$image = imagecreatefrompng ($file_name);

// Set the line thickness:
imagesetthickness($image, 3);

// Plot each person's results...

// x value based upon week number:
$x = ($week * 40) + 40;
$x2 = $x - 40;

foreach ($data as $person => $results) {

	// y value based upon percentage 
	// for that person for that week.
	// Subtract percentage from 100, multiple times 4 (for scale), add 10 for padding.
	$y = ((100 - $results[$week]) * 4) + 10;

	// Make the circle.
	imagefilledellipse ($image, $x, $y, 15, 15, allocate_color($image, $results['color']));
	
	// Connect to the previous week.
	$y2 = ((100 - $results[($week - 1)]) * 4) + 10;
	imageline ($image, $x, $y, $x2, $y2, allocate_color($image, $results['color']));
}

// Save the image on the server:
imagepng ($image, $file_name);

// Destroy the image:
imagedestroy ($image);

// Show the image in the browser:
header ('Content-type: image/png');
readfile($file_name);
?>
