<?php # Script 14.3 - simple.php

/* 	This page creates a simple image.
 *	The image will contain text of one color
 *	on a background of another color.
 */

// Include the allocate_color() function:
require_once('allocate_color.php');

// Define the image information:
$text = 'Zoe Isabella';
$font_size = 4; // Number from 1-5
$text_color = 'white';
$bg_color = 'blue';

// Determine the font height and width.
$font_height = imagefontheight($font_size);
$font_width = imagefontwidth($font_size);

// Adjust the image size (in pixels) based upon the string length...

// Width should be:
// the number of characters plus padding times font size width.
$image_width = (strlen($text) + 2) * $font_width;

// Height should be:
// double the font size height.
$image_height = $font_height * 2;

// Create the image:
$image = imagecreatetruecolor ($image_width, $image_height);

// Add error options if image couldn't be created?
// Possibly send default graphic instead?

// Allocate the background color and fill the image:
$bg_color = allocate_color ($image, $bg_color);
imagefill ($image, 0, 0, $bg_color);

// Allocate the text color and add the text:
$text_color = allocate_color ($image, $text_color);
imagestring ($image, $font_size, $font_width, round($font_height/2), $text, $text_color);

// Make and send the image:
header ('Content-type: image/png');
imagepng ($image);

// Destroy the image:
imagedestroy ($image);
	
?>
